/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/editconfig', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/io',
    'io.ox/office/baseframework/utils/baseconfig'
], function (Utils, IO, BaseConfig) {

    'use strict';

    // static class EditConfig ================================================

    /**
     * Additional static configuration settings for edit applications.
     *
     * @extends BaseConfig
     */
    var EditConfig = _.clone(BaseConfig);

    // constants --------------------------------------------------------------

    /**
     * Specifies whether the local browser storage will be used for saving
     * documents.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.USE_LOCAL_STORAGE = EditConfig.getFlag('useLocalStorage', true);

    /**
     * Specifies whether the current selection of remote users will be
     * displayed in all OX Documents edit applications.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.SHOW_REMOTE_SELECTIONS = EditConfig.getFlag('showRemoteSelections', true);

    /**
     * Specifies whether detailed performance data will be sent to and logged
     * at the server.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.LOG_PERFORMANCE_DATA = EditConfig.getFlag('logPerformanceData', false);

    /**
     * Specifies whether the error and other important data for bug hunting
     * will be sent to and logged by the server.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.LOG_ERROR_DATA = EditConfig.getFlag('logErrorData', false);

    /**
     * Specifies whether the "document name" edit field should be enabled. This
     * ensures that environments which don't support transparent changes of the
     * file name don't break an active RT connection.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.RENAME_DISABLED = EditConfig.getFlag('renamedisabled', false);

    /**
     * Specifies whether the application should support to restore a document.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.ENABLED_RESTORE_DOCUMENT = EditConfig.getFlag('documentRestoreEnabled', true);

    /**
     * Specifies whether the application should load rescue documents in
     * read-only mode.
     *
     * @constant
     *
     * @type {Boolean}
     */
    EditConfig.RESCUE_DOCUMENT_READONLY = EditConfig.getFlag('rescueDocumentReadOnly', true);

    // static methods ---------------------------------------------------------

    /**
     * Retrieves the locale identifiers with a dictionary available for spell
     * checking.
     *
     * @returns {jQuery.Promise}
     *  A promise that will be resolved with an array of strings containing the
     *  locale identifiers with a dictionary available for spell checking.
     */
    EditConfig.getLocalesWithDictionary = _.once(function () {
        return IO.sendRequest('spellchecker', { action: 'supportedlocales' }, { method: 'POST' }).then(function (data) {
            return Utils.getArrayOption(data, 'SupportedLocales', []);
        }, _.constant([]));
    });

    // exports ================================================================

    return EditConfig;

});
