/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/control/chartstylesetpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist',
    'gettext!io.ox/office/drawinglayer/main'
], function (Utils, RadioList, gt) {

    'use strict';

    // class ChartStyleSetPicker ==============================================

    /**
     * A drop-down menu for picking different predefined chart style sets.
     *
     * @constructor
     *
     * @extends RadioList
     */
    function ChartStyleSetPicker(initOptions) {

        // base constructor ---------------------------------------------------

        RadioList.call(this, Utils.extendOptions({
            label: /*#. menu title: predefined style sets for chart objects (e.g. "Light", "Dark", "Colored") */ gt.pgettext('chart-format', 'Style set'),
            tooltip: /*#. menu tooltip: predefined style sets for chart objects (e.g. "Light", "Dark", "Colored") */ gt.pgettext('chart-format', 'Predefined style set'),
            smallerVersion: {
                label: gt.pgettext('chart-format', 'Style')
            }
        }, initOptions, {
            updateCaptionMode: 'none'
        }));

        // initialization -----------------------------------------------------

        this.createOptionButton('ss0', { label: /*#. predefined chart style set: one light color (different shades) */ gt.pgettext('chart-format', 'Light') })
            .createOptionButton('ss4', { label: /*#. predefined chart style set: different colors from color scheme */ gt.pgettext('chart-format', 'Colored') })
            .createOptionButton('ss5', { label: /*#. predefined chart style set: one dark color (different shades) */ gt.pgettext('chart-format', 'Dark') });

    } // class ChartStyleSetPicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: ChartStyleSetPicker });

});
