/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/model/basemodel', [
    'io.ox/office/tk/object/triggerobject',
    'io.ox/office/tk/object/timermixin',
    'io.ox/office/baseframework/app/appobjectmixin'
], function (TriggerObject, TimerMixin, AppObjectMixin) {

    'use strict';

    // class BaseModel ========================================================

    /**
     * The base class for model classes used in OX Documents applications.
     *
     * @constructor
     *
     * @extends TriggerObject
     * @extends TimerMixin
     * @extends AppObjectMixin
     *
     * @param {BaseApplication} app
     *  The application that has created this model instance.
     */
    function BaseModel(app) {

        // base constructors --------------------------------------------------

        TriggerObject.call(this);
        TimerMixin.call(this);
        AppObjectMixin.call(this, app);

        // public methods -----------------------------------------------------

        /**
         * Returns the application instance that owns this document model.
         *
         * @returns {BaseApplication}
         *  The application instance that owns this document model.
         */
        this.getApp = function () {
            return app;
        };

        /**
         * Returns a reference to this document model. Provided to allow to
         * implement functions that can take any model object (instances of the
         * class ModelObject), including this document model itself.
         *
         * @returns {BaseModel}
         *  A reference to this instance.
         */
        this.getDocModel = function () {
            return this;
        };

    } // class BaseModel

    // exports ================================================================

    // derive this class from class TriggerObject
    return TriggerObject.extend({ constructor: BaseModel });

});
