/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/tk/locale/localedata'
], function (LocaleData) {

    'use strict';

    // static class LocaleData ================================================

    describe('Toolkit module LocaleData', function () {

        it('should exist', function () {
            expect(LocaleData).to.be.an('object');
        });

        // constants ----------------------------------------------------------

        describe('constant', function () {
            it('"LOCALE" should exist', function () {
                expect(LocaleData).to.have.a.property('LOCALE').that.is.a('string');
            });
            it('"LANGUAGE" should exist', function () {
                expect(LocaleData).to.have.a.property('LANGUAGE').that.is.a('string');
            });
            it('"COUNTRY" should exist', function () {
                expect(LocaleData).to.have.a.property('COUNTRY').that.is.a('string');
            });
            it('"LCID" should exist', function () {
                expect(LocaleData).to.have.a.property('LCID').that.is.a('number');
            });
            it('"DEC" should exist', function () {
                expect(LocaleData).to.have.a.property('DEC').that.is.a('string');
            });
            it('"GROUP" should exist', function () {
                expect(LocaleData).to.have.a.property('GROUP').that.is.a('string');
            });
            it('"DIR" should exist', function () {
                expect(LocaleData).to.have.a.property('DIR').that.is.a('string');
            });
            it('"CJK" should exist', function () {
                expect(LocaleData).to.have.a.property('CJK').that.is.a('boolean');
            });
            it('"UNIT" should exist', function () {
                expect(LocaleData).to.have.a.property('UNIT').that.is.a('string');
            });
            it('"CURRENCY" should exist', function () {
                expect(LocaleData).to.have.a.property('CURRENCY').that.is.a('string');
            });
            it('"ISO_CURRENCY" should exist', function () {
                expect(LocaleData).to.have.a.property('ISO_CURRENCY').that.is.a('string');
            });
            it('"SHORT_DATE" should exist', function () {
                expect(LocaleData).to.have.a.property('SHORT_DATE').that.is.a('string');
            });
            it('"LONG_DATE" should exist', function () {
                expect(LocaleData).to.have.a.property('LONG_DATE').that.is.a('string');
            });
            it('"SHORT_TIME" should exist', function () {
                expect(LocaleData).to.have.a.property('SHORT_TIME').that.is.a('string');
            });
            it('"LONG_TIME" should exist', function () {
                expect(LocaleData).to.have.a.property('LONG_TIME').that.is.a('string');
            });
            it('"LEADING_MONTH" should exist', function () {
                expect(LocaleData).to.have.a.property('LEADING_MONTH').that.is.a('boolean');
            });
            it('"LEADING_YEAR" should exist', function () {
                expect(LocaleData).to.have.a.property('LEADING_YEAR').that.is.a('boolean');
            });
            it('"HOURS24" should exist', function () {
                expect(LocaleData).to.have.a.property('HOURS24').that.is.a('boolean');
            });
            it('"TOKENS" should exist', function () {
                expect(LocaleData).to.have.a.property('TOKENS').that.is.an('object');
            });
            it('"QUARTER" should exist', function () {
                expect(LocaleData).to.have.a.property('QUARTER').that.is.an('array');
            });
            it('"QUARTERABBR" should exist', function () {
                expect(LocaleData).to.have.a.property('QUARTERABBR').that.is.an('array');
            });
        });

        // static methods -----------------------------------------------------

        describe('method "getAll"', function () {
            it('should exist', function () {
                expect(LocaleData).itself.to.respondTo('getAll');
            });
            it('should return a map with locale data entries', function () {
                var dataMap = LocaleData.getAll();
                expect(dataMap).to.be.an('object');
                expect(dataMap).to.have.a.property('en_US').that.is.an('object').with.property('lc', 'en_US');
                expect(dataMap).to.have.a.property('de_DE').that.is.an('object').with.property('lc', 'de_DE');
            });
        });

        describe('method "get"', function () {
            it('should exist', function () {
                expect(LocaleData).itself.to.respondTo('get');
            });
            it('should return the "en_US" locale by locale code', function () {
                var data = LocaleData.get('en_US');
                expect(data).to.be.an('object');
                expect(data).to.have.a.property('lc').that.equals('en_US');
                expect(data).to.have.a.property('language').that.equals('en');
                expect(data).to.have.a.property('country').that.equals('US');
                expect(data).to.have.a.property('lcid').that.equals(1033);
                expect(data).to.have.a.property('name').that.is.a('string');
                expect(data).to.have.a.property('cjk').that.equals(false);
                expect(data).to.have.a.property('leadingMonth').that.equals(true);
                expect(data).to.have.a.property('leadingYear').that.equals(false);
                expect(data).to.have.a.property('hours24').that.equals(false);
                expect(data).to.have.a.property('tokens').that.deep.equals({ D: 'D', M: 'M', Y: 'Y', h: 'h', m: 'm', s: 's', b: 'b', g: 'g', e: 'e' });
            });
            it('should return the "de_DE" locale by locale code', function () {
                var data = LocaleData.get('de_DE');
                expect(data).to.be.an('object');
                expect(data).to.have.a.property('lc').that.equals('de_DE');
                expect(data).to.have.a.property('language').that.equals('de');
                expect(data).to.have.a.property('country').that.equals('DE');
                expect(data).to.have.a.property('lcid').that.equals(1031);
                expect(data).to.have.a.property('name').that.is.a('string');
                expect(data).to.have.a.property('cjk').that.equals(false);
                expect(data).to.have.a.property('leadingMonth').that.equals(false);
                expect(data).to.have.a.property('leadingYear').that.equals(false);
                expect(data).to.have.a.property('hours24').that.equals(true);
                expect(data).to.have.a.property('tokens').that.deep.equals({ D: 'T', M: 'M', Y: 'J', h: 'h', m: 'm', s: 's', b: 'b', g: 'g', e: 'e' });
            });
            it('should return the "ja_JP" locale by locale code', function () {
                var data = LocaleData.get('ja_JP');
                expect(data).to.be.an('object');
                expect(data).to.have.a.property('lc').that.equals('ja_JP');
                expect(data).to.have.a.property('language').that.equals('ja');
                expect(data).to.have.a.property('country').that.equals('JP');
                expect(data).to.have.a.property('lcid').that.equals(1041);
                expect(data).to.have.a.property('name').that.is.a('string');
                expect(data).to.have.a.property('cjk').that.equals(true);
                expect(data).to.have.a.property('leadingMonth').that.equals(true);
                expect(data).to.have.a.property('leadingYear').that.equals(true);
                expect(data).to.have.a.property('hours24').that.equals(true);
                expect(data).to.have.a.property('tokens').that.deep.equals({ D: 'D', M: 'M', Y: 'Y', h: 'h', m: 'm', s: 's', b: 'b', g: 'g', e: 'e' });
            });
            it('should return the "en_US" locale by MS locale identifier', function () {
                var data = LocaleData.get(1033);
                expect(data).to.be.an('object');
                expect(data).to.have.a.property('lc').that.equals('en_US');
                expect(data).to.have.a.property('lcid').that.equals(1033);
            });
            it('should return the "de_DE" locale by MS locale identifier', function () {
                var data = LocaleData.get(1031);
                expect(data).to.be.an('object');
                expect(data).to.have.a.property('lc').that.equals('de_DE');
                expect(data).to.have.a.property('lcid').that.equals(1031);
            });
            it('should return the "de_DE" locale as UI locale', function () {
                var data = LocaleData.get();
                expect(data).to.be.an('object');
                expect(data).to.have.a.property('lc').that.equals('de_DE');
            });
            it('should fall back to "en_US" for invalid parameter', function () {
                expect(LocaleData.get('__invalid__')).to.equal(LocaleData.get('en_US'));
                expect(LocaleData.get(-1)).to.equal(LocaleData.get('en_US'));
            });
        });
    });

    // ========================================================================
});
