/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/textframework/selection/selection'
], function (AppHelper, Selection) {

    'use strict';

    // class Selection ===========================================================

    describe('Text class Selection', function () {

        it('should exist', function () {
            expect(Selection).to.be.a('function');
        });

        // private helpers ----------------------------------------------------

        // the operations to be applied by the document model
        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { defaultTabStop: 1270, zoom: { value: 100 } }, page: { width: 21590, height: 27940, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 1248 } } },
            { name: 'insertParagraph', start: [0] },
            { name: 'splitParagraph', start: [0, 0] },
            { name: 'insertText', text: 'Hello World', start: [1, 0] },
            { name: 'splitParagraph', start: [1, 0] },
            { name: 'setAttributes', start: [2], attrs: { paragraph: { pageBreakBefore: true } } },
            { name: 'splitParagraph', start: [2, 0] },
            { name: 'setAttributes', start: [3], attrs: { paragraph: { pageBreakBefore: true } } }
        ];

        var model, selection, pageLayout;
        AppHelper.createTextApp('ooxml', OPERATIONS).done(function (app) {
            model = app.getModel();
            selection = model.getSelection();
            pageLayout = model.getPageLayout();
        });

        // constructor --------------------------------------------------------

        describe('constructor', function () {
            it('should create a Selection class instance', function () {
                expect(selection).to.be.an['instanceof'](Selection);
            });
        });

        // public methods -----------------------------------------------------

        before(function () {
            pageLayout.callInitialPageBreaks();
        });

        describe('method "getFirstDocumentPosition"', function () {
            it('should return correct first oxo position in document', function () {
                expect(selection.getFirstDocumentPosition()).to.eql([0, 0]);
            });
        });

        describe('method "getLastDocumentPosition"', function () {
            it('should return correct last oxo position in document', function () {
                expect(selection.getLastDocumentPosition()).to.eql([3, 11]);
            });
        });

        describe('method "isAllSelected"', function () {
            it('should not be true when not all is selected in document', function () {
                expect(selection.isAllSelected()).to.equal(false);
            });
        });

        describe('method "selectAll"', function () {
            before(function () {
                selection.selectAll();
            });

            it('should be true when all is selected in document', function () {
                expect(selection.isAllSelected()).to.equal(true);
            });
        });

    });

    // ========================================================================
});
