
module.exports = (function () {

    'use strict';

    var Path = require('path');

    var root = require.main.filename;
    while (Path.basename(root) !== 'perf') {
        root = Path.dirname(root);
    }

    function noop() { return this; }

    var document = GLOBAL.document = {};
    document.body = {};
    document.addEventListener = noop;

    var window = GLOBAL.window = {};
    window.document = document;
    window.console = GLOBAL.console;

    var _ = GLOBAL._ = require('underscore');
    _.device = noop;
    _.browser = {};
    _.makeExtendable = _.identity;

    var jq = [{}];
    jq.prependTo = jq.append = jq.remove = jq.on = jq.off = noop;
    jq.width = jq.height = _.constant(1);
    var $ = GLOBAL.$ = _.constant(jq);
    $.noop = noop;

    GLOBAL.ox = { language: 'en_US' };

    var modules = {};

    // mocked core modules
    modules['io.ox/core/event'] = { extend: function (obj) {
        obj.on = obj.off = obj.one = obj.trigger = noop;
        return obj;
    } };
    modules['io.ox/core/api/user'] = {};

    GLOBAL.define = function (name, deps, def) {

        if (!def) { def = deps; deps = []; }

        deps = deps.map(function (dep) {
            if (!(dep in modules)) {
                if (/^less!/.test(dep)) {
                    modules[dep] = {};
                } else if (/^settings!/.test(dep)) {
                    modules[dep] = { get: noop };
                } else if (/^perf!/.test(dep)) {
                    dep = dep.substr(dep.indexOf('!') + 1);
                    require(Path.join(root, dep));
                } else {
                    require('../../apps/' + dep);
                }
            }
            return modules[dep];
        });

        return (modules[name] = def.apply(null, deps));
    };

    return GLOBAL.define;
}());
