'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.api = exports.plugins = exports.types = exports.ModuleSpecifier = exports.ModuleDeclaration = exports.Fragment = exports.Token = exports.Node = exports.Element = exports.visitorKeys = exports.Parser = undefined;

var _Parser = require('./Parser');

Object.defineProperty(exports, 'Parser', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_Parser).default;
    }
});

var _visitorKeys = require('./visitorKeys');

Object.defineProperty(exports, 'visitorKeys', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_visitorKeys).default;
    }
});

var _Element = require('./elements/Element');

Object.defineProperty(exports, 'Element', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_Element).default;
    }
});

var _Node = require('./elements/Node');

Object.defineProperty(exports, 'Node', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_Node).default;
    }
});

var _Token = require('./elements/Token');

Object.defineProperty(exports, 'Token', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_Token).default;
    }
});

var _Fragment = require('./elements/Fragment');

Object.defineProperty(exports, 'Fragment', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_Fragment).default;
    }
});

var _ModuleDeclaration = require('./elements/ModuleDeclaration');

Object.defineProperty(exports, 'ModuleDeclaration', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_ModuleDeclaration).default;
    }
});

var _ModuleSpecifier = require('./elements/ModuleSpecifier');

Object.defineProperty(exports, 'ModuleSpecifier', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_ModuleSpecifier).default;
    }
});

var _elementIndex = require('./elements/elementIndex');

Object.defineProperty(exports, 'types', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_elementIndex).default;
    }
});

var _pluginsIndex = require('./plugins/pluginsIndex');

Object.defineProperty(exports, 'plugins', {
    enumerable: true,
    get: function get() {
        return _interopRequireDefault(_pluginsIndex).default;
    }
});

var _sourceMapSupport = require('source-map-support');

var _ScopesApi = require('./plugins/scopes/ScopesApi');

var _ScopesApi2 = _interopRequireDefault(_ScopesApi);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Install sourcemaps
(0, _sourceMapSupport.install)();

var api = exports.api = {
    ScopesApi: _ScopesApi2.default
};
//# sourceMappingURL=index.js.map