'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _Expression2 = require('../Expression');

var _Expression3 = _interopRequireDefault(_Expression2);

var _getFunctionParams = require('./utils/getFunctionParams');

var _getFunctionParams2 = _interopRequireDefault(_getFunctionParams);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FunctionExpression = function (_Expression) {
    (0, _inherits3.default)(FunctionExpression, _Expression);

    // TODO: get params from Property in case of setter

    function FunctionExpression(childNodes) {
        (0, _classCallCheck3.default)(this, FunctionExpression);

        var _this = (0, _possibleConstructorReturn3.default)(this, (FunctionExpression.__proto__ || (0, _getPrototypeOf2.default)(FunctionExpression)).call(this, 'FunctionExpression', childNodes));

        _this._short = false;
        _this._generatorFromProperty = false;
        _this.expression = false;
        _this.isFunction = true;
        return _this;
    }

    (0, _createClass3.default)(FunctionExpression, [{
        key: '_acceptChildren',
        value: function _acceptChildren(children) {
            var params = [];
            var id = null;
            var generator = false;
            var async = false;
            var short = false;

            if (children.isToken('Punctuator', '(')) {
                params = (0, _getFunctionParams2.default)(children);
                children.skipNonCode();
            } else {
                if (children.isToken('Identifier', 'async')) {
                    async = true;
                    children.passToken('Identifier', 'async');
                    children.skipNonCode();
                }

                children.passToken('Keyword', 'function');
                children.skipNonCode();

                if (children.isToken('Punctuator', '*')) {
                    generator = true;
                    children.moveNext();
                    children.skipNonCode();
                }

                if (children.isNode('Identifier')) {
                    id = children.passNode();
                    children.skipNonCode();
                }

                params = (0, _getFunctionParams2.default)(children);
                children.skipNonCode();
            }

            var body = children.passStatement();

            children.assertEnd();

            this.async = async;
            this.id = id;
            this.params = params;
            this.body = body;
            this.generator = generator;
            this._short = short;
        }
    }, {
        key: '_onSetParentElement',
        value: function _onSetParentElement(parentElement) {
            if (parentElement && (parentElement.type === 'Property' || parentElement.type === 'ClassMethod')) {
                this._short = true;
                this._generatorFromProperty = parentElement._generator;
            } else {
                this._short = false;
                this._generatorFromProperty = false;
            }
            this.generator = this._short ? this._generatorFromProperty : this.generator;
        }
    }]);
    return FunctionExpression;
}(_Expression3.default);

exports.default = FunctionExpression;
//# sourceMappingURL=FunctionExpression.js.map