/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 */

define('io.ox/office/text/app/mailcomposemodification', [

    'io.ox/office/tk/utils',

    // workaround for Bug 46664
    // loading only MailComposeView forced a Bug in the TokenField of the mailcomposer
    'io.ox/mail/compose/main',
    'io.ox/mail/compose/bundle',
    'io.ox/mail/compose/view',
    'io.ox/mail/compose/model',

    'io.ox/core/extensions',
    'io.ox/files/api'

], function (Utils, MailComposeMain, MailComposeBundle, MailComposeView, MailComposeModel, CoreExtensions, FilesApi) {

    'use strict';

  //Utils.info('mailcomposemodification :: [MailComposeView, CoreExtensions]: ', MailComposeView, CoreExtensions);

    var
        collectToBeDeletedItemsAfterMailComposeFromAttachmentModelList = function (collector, attachmentModel) {
            var
                disp     = attachmentModel.get('disp'),
                isDelete = attachmentModel.get('is_delete_after_mail_compose');

            if ((isDelete === true) && (disp === 'attachment')) {
                collector.push({
                    id:         attachmentModel.get('id'),
                    folder_id:  attachmentModel.get('folder_id')
                });
            }
            return collector;
        },

        isToBeDeletedAttachmentAfterMailCompose = function (attachment/*, idx, list*/) {
            return (
                (attachment.is_delete_after_mail_compose === true) &&
                (attachment.disp === 'attachment')
            );
        },

        extensionPointComposeButtons = CoreExtensions.point('io.ox/mail/compose/buttons'),
        extensionPointSendActions    = CoreExtensions.point('io.ox/mail/compose/actions/send');

//  ox.on('mail:compose:discard', function (/*baton*/) {
//      Utils.info('mailcomposemodification :: handle event mail discard :: arguments : ', arguments);
//  });

    /*
     *  - An ox extension point might come closest to the term "Pointcut" as it is featured by
     *    the aspect oriented (AO) approach which is a pattern for dealing with cross cutting concerns.
     *  - A Pointcut can be seen as a list of so called "Joinpoint"s.
     *  - Each Joinpoint is ought to be augmented by an "Advice" which is the AO term for
     *    additional behavior that might be applied or not.
     *  - An Advice can be applied just via one or many Pointcuts.
     *  - The trigger mechanism that folds Advices and Pointcuts each one by one at the time
     *    is bundled into or or more so called "Aspect"s.
     *
     *  - Thus this module and its entire code beneath can be seen as a special Aspect that
     *    modifies already existing behavior that is provided by ox extension points.
     */

    extensionPointComposeButtons.reduce(function (deferred, extensionPoint) {
      //Utils.info('mailcomposemodification :: extensions point :: [deferred, extensionPoint] : ', [deferred, extensionPoint]);
        if (extensionPoint.id === 'discard') {
            /**
             *  modify extension point id 'discard' as of file 'io.ox/mail/compose/view':
             *
             *  - line 51 / code block:
             *    {
             *       index: 300,
             *       id: 'discard',
             *       draw: extensions.buttons.discard
             *    }
             */
            extensionPoint.draw = (function (proceed) {
              //Utils.info('mailcomposemodification :: DISCARD-UI / overwrite :: proceed : ', proceed);
                return function (baton) {

                  //Utils.info('mailcomposemodification :: DISCARD-UI / intercepted / BEFORE :: [proceed, baton, $target] : ', proceed, baton, $('[data-extension-id="header"]').eq(0));
                    var
                        $target = baton.$header,
                      //$result = proceed.apply($target, arguments),

                        attachmentModelList = baton.model.get('attachments'),
                        toBeDeletedItemList = attachmentModelList.models.reduce(collectToBeDeletedItemsAfterMailComposeFromAttachmentModelList, []);

                    proceed.apply($target, arguments);

                    attachmentModelList.listenTo(attachmentModelList, 'remove', function (attachment) {
                      //Utils.info('++++ remove event +++ attachment : ', attachment);
                        var
                            list = toBeDeletedItemList.filter(function (item) {
                                return (item.id === attachment.id);
                            });

                        if (list.length) {

                            toBeDeletedItemList = toBeDeletedItemList.filter(function (item) {
                                return (item.id !== attachment.id);
                            });
                            FilesApi.remove(list, true);
                        }
                    });/*

                  //Utils.info('mailcomposemodification :: DISCARD-UI / intercepted / AFTER :: result : ', $result);
                    $result.on('click', function () {

                      //Utils.info('mailcomposemodification :: DISCARD-UI / intercepted / discard:click :: baton : ', baton);
                      //Utils.info('mailcomposemodification :: DISCARD-UI / intercepted / discard:click :: attachmentModelList : ', attachmentModelList);
                      //Utils.info('mailcomposemodification :: DISCARD-UI / intercepted / discard:click :: toBeDeletedItemList : ', toBeDeletedItemList);
                        if (toBeDeletedItemList.length) {

                            FilesApi.remove(toBeDeletedItemList, true);
                        }
                    });*/

                    /**
                     *  modify a mail compose model instance's 'discard' method  as of file ''io.ox/mail/compose/model'':
                     *
                     *  - line 344 / code block:
                     *
                     *  discard: function () {
                     *    // never delete on edit
                     *    // only delete autosaved drafts that are not saved manually and have a msgref
                     *    if (this.get('autoDismiss')) return;
                     *    if (this.get('autosavedAsDraft') && this.get('msgref')) mailAPI.remove([mailUtil.parseMsgref(mailAPI.separator, this.get('msgref'))]);
                     *  },
                     */
                    baton.model.discard = (function (model, proceed) {
                        return function () {

                            Utils.info('+++ model.discard +++');
                            Utils.info('+++ model.get("autoDismiss") : ', model.get('autoDismiss'));

                          //if ((model.get('autoDismiss') === false) && (toBeDeletedItemList.length >= 1)) {
                            if (toBeDeletedItemList.length >= 1) {

                                FilesApi.remove(toBeDeletedItemList, true);
                            }
                            return proceed.call(model);
                        };
                    }(baton.model, baton.model.discard));

                    /**
                     *  modify a mail compose model instance's 'getMailForDraft' method  as of file ''io.ox/mail/compose/model'':
                     *
                     *  - line 316 / code block:
                     *
                     *  getMailForDraft: function () {
                     *    var mail = this.getMail();
                     *
                     *    if (_(mail.flags).isUndefined()) {
                     *      mail.flags = mailAPI.FLAGS.DRAFT;
                     *    } else if ((mail.data.flags & 4) === 0) {
                     *      mail.flags += mailAPI.FLAGS.DRAFT;
                     *    }
                     *
                     *    return mail;
                     *  }
                     */
                    baton.model.getMailForDraft = (function (model, proceed) {
                        return function () {

                            Utils.info('+++ model.getMailForDraft +++');
                            Utils.info('+++ model.get("autoDismiss") : ', model.get('autoDismiss'));

                            var
                                result = proceed.call(model); // mail

                          //if ((model.get('autoDismiss') === true) && (toBeDeletedItemList.length >= 1)) {
                            if (toBeDeletedItemList.length >= 1) {

                              //FilesApi.remove(toBeDeletedItemList, true);

                                window.setTimeout((function (FilesApi, toBeDeletedItemList) {
                                    return function () {

                                        FilesApi.remove(toBeDeletedItemList, true);
                                    };
                                }(FilesApi, toBeDeletedItemList)), 1000);
                            }
                            return result; // mail
                        };
                    }(baton.model, baton.model.getMailForDraft));

                };
            }(extensionPoint.draw));
        }
    });

    extensionPointSendActions.reduce(function (deferred, extensionPoint) {
      //Utils.info('mailcomposemodification :: extensions point :: [deferred, extensionPoint] : ', [deferred, extensionPoint]);
        if (extensionPoint.id === 'send') {
            /**
             *  modify extension point id 'send' as of file 'io.ox/mail/compose/actions/send':
             *
             *  - line 153 / code block:
             *    {
             *      id: 'send',
             *      index: 1000,
             *      perform: function (baton) {
             *        return mailAPI.send(baton.mail, baton.mail.files);
             *      }
             *    }
             */
            extensionPoint.perform = (function (proceed) {
                return function (baton) {
                    var
                        attachmentList = baton.mail.attachments.filter(isToBeDeletedAttachmentAfterMailCompose);

                    return proceed.apply(null, arguments).always(function () {
                        FilesApi.remove(attachmentList, true);
                    });
                };
            }(extensionPoint.perform));
        }
    });

});
