/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/cellbordermodepicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/view/control/bordermodepicker',
    'io.ox/office/spreadsheet/view/labels'
], function (Utils, BorderModePicker, Labels) {

    'use strict';

    // class CellBorderModePicker =============================================

    /**
     * The selector for cell borders. Hides specific items in the drop-down
     * menu, according to the current cell selection.
     *
     * @constructor
     *
     * @extends BorderModePicker
     *
     * @param {SpreadsheetView} docView
     *  The spreadsheet view containing this instance.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options that are also supported by
     *  the base class BorderModePicker, except for the options 'showInsideHor'
     *  and 'showInsideVert' which will be initialized internally to reflect
     *  the current sheet selection.
     */
    function CellBorderModePicker(docView, initOptions) {

        // base constructor ---------------------------------------------------

        BorderModePicker.call(this, Utils.extendOptions({
            tooltip: Labels.CELL_BORDERS_LABEL
        }, initOptions, {
            showInsideHor: showInsideHorBorder,
            showInsideVert: showInsideVertBorder
        }));

        // private methods ----------------------------------------------------

        /**
         * Returns whether the list entries containing inner horizontal borders
         * are currently visible (selection contains multiple rows).
         *
         * @returns {Boolean}
         *  Whether inner horizontal borders are currently visible.
         */
        function showInsideHorBorder() {
            return docView.hasMultipleRowsSelected();
        }

        /**
         * Returns whether the list entries containing inner vertical borders
         * are currently visible (selection contains multiple columns).
         *
         * @returns {Boolean}
         *  Whether inner vertical borders are currently visible.
         */
        function showInsideVertBorder() {
            return docView.hasMultipleColumnsSelected();
        }

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = initOptions = null;
        });

    } // class CellBorderModePicker

    // exports ================================================================

    // derive this class from class BorderModePicker
    return BorderModePicker.extend({ constructor: CellBorderModePicker });

});
