/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/formula/utils/formulaerror', function () {

    'use strict';

    // class FormulaError =====================================================

    /**
     * A special exception to be thrown during parsing, compiling, or
     * interpreting spreadsheet formulas.
     *
     * @constructor
     *
     * @extends Error
     *
     * @property {String} type
     *  A type specifier for the error. The following types are supported:
     *  - 'missing': The end of the formula has been reached unexpectedly (e.g.
     *      incomplete formula).
     *  - 'unexpected': A token with an invalid type, or invalid garbage at the
     *      end of the formula has been found.
     *  - 'reference': an invalid token has been found where a reference token
     *      was expected.
     */
    function FormulaError(message, type) {

        this.name = 'OperationError';
        this.message = message;
        this.type = type;

    } // class FormulaError

    // derive manually from built-in class Error
    FormulaError.prototype = Object.create(Error.prototype);
    FormulaError.prototype.constructor = FormulaError;

    // exports ================================================================

    return FormulaError;

});
