/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/portal/presentation/fulltour', [
    'io.ox/office/portal/portaltour',
    'gettext!io.ox/office/portal/main'
], function (PortalTour, gt) {

    'use strict';

    // class PresentationFullTour =============================================

    /**
     * The guided tour for the Presentation Portal application.
     *
     * @constructor
     *
     * @extends PortalTour
     */
    var PresentationFullTour = PortalTour.extend({ constructor: function (options) {

        // whether to show the short version of the presentation tour
        var shortTour = options && options.auto && PortalTour.isAnyPortalTourShown();

        // base constructor ---------------------------------------------------

        PortalTour.call(this, 'presentation');

        // initialization -----------------------------------------------------

        // the initial welcome message
        this.welcomeStep()
            .title(gt.pgettext('tour', 'The Presentation app'))
            .content(gt.pgettext('tour', 'Welcome to your new Presentation app. This Guided Tour will introduce you to the most important functions of creating and editing presentations online.'));

        // do not show the following steps in the short version of the tour
        if (!shortTour) {

            // highlight the header of the template area
            this.templatesAreaStep()
                .title(gt.pgettext('tour', 'Templates'))
                .content(gt.pgettext('tour', 'Clicking on the Presentation app in the navigation bar displays an overview of all the templates available to you in Presentation.'));

            // describe the 'Blank document' button
            this.blankDocumentStep()
                .title(gt.pgettext('tour', 'Blank presentation'))
                .content(gt.pgettext('tour', 'You can choose from a variety of templates to help you create professional presentations.'))
                .content($('<br>'))
                .content(gt.pgettext('tour', 'Let\'s start with a blank presentation.'));
        }

        // launch the editor application with a new empty document
        this.launchDocumentStep();

        // do not show the following steps in the short version of the tour
        if (!shortTour) {

            // insert document contents, show the 'Saving changes' label
            this.autoSaveStep(function () {
                this.getDocModel().insertText('Lorem ipsum dolor sit amet.', [0, 0, 0, 0]);
            });

            // describe the 'File' toolbar
            this.fileTabStep();
            this.saveAsStep();
            this.sendAsMailStep();
        }

        // TODO: presentation specific stuff here...

        // describe the 'Close' button, switch to 'Documents' folder in Drive
        if (!shortTour) {
            this.closeButtonStep();
            this.documentsFolderStep();
        }

        // final tour step describing how to restart the tour, return to Drive application with the Back button
        this.restartTourStep().on('back', (shortTour ? this.launchEditorApp : this.launchDriveApp).bind(this));

    } }); // class PresentationFullTour

    // exports ================================================================

    return PresentationFullTour;

});
