/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/model/documentmodel', [
    'io.ox/office/tk/utils/driveutils'
], function (DriveUtils) {

    'use strict';

    var documentModel = Backbone.Model.extend({

        defaults: function () {
            return { previewWidth: 40 };
        },

        initialize: function () {
            this.set('previewURL', DriveUtils.getFileUrl(this.attributes, 'preview'));
            this.set('source', 'drive');
        }

    });

    return documentModel;

});
