/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/compoundsplitbutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/tk/control/button',
    'io.ox/office/baseframework/view/control/compoundmenumixin'
], function (Utils, Forms, Button, CompoundMenuMixin) {

    'use strict';

    // class CompoundSplitButton ==============================================

    /**
     * A button control with a combined drop-down menu containing a complete
     * self-contained view component instance with completely independent
     * controls. See class CompoundButton for a similar simple drop-down
     * control, but without additional split button control.
     *
     * @constructor
     *
     * @extends Button
     * @extends CompoundMenuMixin
     *
     * @param {BaseView} docView
     *  The document view instance containing this control.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options also supported by the base
     *  class Button, and the mix-in class CompoundMenuMixin.
     */
    function CompoundSplitButton(docView, initOptions) {

        var // the drop-down button
            menuButton = $(Forms.createButtonMarkup());

        // base constructors --------------------------------------------------

        Button.call(this, initOptions);
        CompoundMenuMixin.call(this, docView, Utils.extendOptions(initOptions, { button: menuButton }));

        this.getNode().addClass('compund-split-group');

        // initialization -----------------------------------------------------

        Forms.setToolTip(menuButton, {
            tooltip: Utils.getStringOption(initOptions, 'caretTooltip', Utils.getStringOption(initOptions, 'tooltip', ''))
        });

        // add the drop-down button to the group
        this.addChildNodes(menuButton);

        // destroy all class members
        this.registerDestructor(function () {
            docView = initOptions = menuButton = null;
        });

    } // class CompoundSplitButton

    // exports ================================================================

    // derive this class from class Button
    return Button.extend({ constructor: CompoundSplitButton });

});
