/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

(function (define, require) {

    'use strict';

    // define.async() ---------------------------------------------------------

    window.define.async = function (name, deps, callback) {

        function loadAsync(n, parentReq, onLoad) {
            // resolve module dependencies
            parentReq(deps, function () {

                // run module definition (must return a promise)
                var promise = callback.apply(null, arguments);
                if (promise && promise.done) {
                    promise.done(onLoad);
                } else if (console.error) {
                    console.error('Module "' + name + '" does not return a promise!');
                }
                name = deps = callback = null;
            });
        }

        // use loader plug-in to defer module definition
        define(name + ':init', { load: loadAsync });

        // define real module - will wait for promise
        define(name, [name + ':init!'], _.identity);
    };

    // require() with promises ------------------------------------------------

    window.require = function (deps, success, fail) {

        // return a deferred object, if an array of dependencies has been required
        if (_.isArray(deps)) {
            var def = $.Deferred().done(success).fail(fail || function (error) {
                console.error('require: Error in ' + error.requireModules, error.stack);
            });
            require(deps, def.resolve, def.reject);
            return def.promise();
        }

        // bypass
        return require.apply(this, arguments);
    };

    _.extend(window.require, require);

    // text plug-ins ----------------------------------------------------------

    // loads a file via AJAX request
    function ajax(name, type, onLoad, config) {
        return $.ajax({ url: config.baseUrl + name, dataType: type }).then(
            onLoad,
            function fail() {
                // this simple line might save life time
                console.error('Cannot load ' + type + ' file', name, arguments);
                onLoad.error.apply(onLoad, arguments);
            }
        );
    }

    define('text', {
        load: function (name, parentReq, onLoad, config) {
            return ajax(name, 'text', onLoad, config);
        }
    });

    define('json', {
        load: function (name, parentReq, onLoad, config) {
            return ajax(name + '.json', 'json', onLoad, config);
        }
    });

    // LESS plug-in -----------------------------------------------------------

    define('less', {
        load: function loadLess(name, parentReq, onLoad) {
            onLoad();
        }
    });

}(window.define, window.require));
