define('io.ox/core/gettext', function () {

    'use strict';

    function gt() {
        var gt = function (text) {
            var args = arguments;
            return text.replace(/%(\d+)\$[ds]/g, function (match, index) {
                return args[index];
            });
        };
        gt.pgettext = function (ctxt, text) { return gt(text); };
        gt.npgettext = function (ctxt, ctxt2, text) { return gt(text); };
        gt.format = function (text, opt) { return gt(text); };
        return gt;
    }

    return gt;
});

define('gettext', {
    load: function (name, parentRequire, load) {
        parentRequire([name + '.en_US'], load);
    }
});
