/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Miroslav Dzunic <miroslav.dzunic@open-xchange.com>
 */

define([
    'io.ox/office/textframework/components/pagelayout/pagelayout'
], function (PageLayout) {

    'use strict';

    // class PageLayout ===========================================================

    describe('Text class PageLayout', function () {

        it('should exist', function () {
            expect(PageLayout).to.be.a('function');
        });

        // private helpers ----------------------------------------------------

        var model = null;
        var pageLayout = null;
        var view = null;

        // the operations to be applied by the document model
        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { defaultTabStop: 1270, zoom: { value: 100 } }, page: { width: 21590, height: 27940, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 1248 } } },
            { name: 'insertParagraph', start: [0] },
            { name: 'splitParagraph', start: [0, 0] },
            { name: 'insertText', text: 'Hello World', start: [1, 0] },
            { name: 'splitParagraph', start: [1, 0] },
            { name: 'setAttributes', start: [2], attrs: { paragraph: { pageBreakBefore: true } } },
            { name: 'splitParagraph', start: [2, 0] },
            { name: 'setAttributes', start: [3], attrs: { paragraph: { pageBreakBefore: true } } }
        ];

        before(function (done) {
            ox.test.text.createApp('ooxml', OPERATIONS).done(function (app) {
                model = app.getModel();
                view = app.getView();
                pageLayout = model.getPageLayout();
                //pageLayout = new PageLayout(model, app.getView().getContentRootNode());
                done();
            });
        });

        // constructor --------------------------------------------------------
        describe('constructor', function () {
            it('should create a PageLayout class instance', function () {
                expect(new PageLayout(model, view.getContentRootNode())).to.be.an['instanceof'](PageLayout);
            });
        });

        // public methods -----------------------------------------------------

        describe('method "getHeaderFooterPlaceHolder"', function () {
            it('should exist', function () {
                expect(pageLayout).to.respondTo('getHeaderFooterPlaceHolder');
            });
            it('should return headerFooter placeholder node', function () {
                expect(pageLayout.getHeaderFooterPlaceHolder()).to.be.an['instanceof']($);
            });
        });

        describe('method "getallHeadersAndFooters"', function () {
            it('should exist', function () {
                expect(pageLayout).to.respondTo('getallHeadersAndFooters');
            });
            it('should return all headers and footers in document', function () {
                expect(pageLayout.getallHeadersAndFooters()).to.be.an['instanceof']($);
            });
        });

        describe('group of methods with pre-requirement of initial page breaks called', function () {
            before(function () {
                pageLayout.callInitialPageBreaks();
            });

            describe('method "getPageNumber"', function () {
                it('should exist', function () {
                    expect(pageLayout).to.respondTo('getPageNumber');
                });
                it('should return the current page number of the selection', function () {
                    expect(pageLayout.getPageNumber()).to.equal(1);
                });
            });

            describe('existence of first and last header/footer wrappers', function () {
                it('should return that first header wrapper exists in document', function () {
                    expect(pageLayout.isExistingFirstHeaderWrapper()).to.equal(true);
                });
                it('should return that last footer wrapper exists in document', function () {
                    expect(pageLayout.isExistingLastFooterWrapper()).to.equal(true);
                });

            });

            describe('method "getPageAttribute"', function () {
                it('should exist', function () {
                    expect(pageLayout).to.respondTo('getPageAttribute');
                });
                it('should return that first page header is not set in document', function () {
                    expect(pageLayout.getPageAttribute('firstPage')).to.equal(false);
                });
                it('should return that even/odd pages headers are not set in document', function () {
                    expect(pageLayout.getPageAttribute('evenOddPages')).to.equal(false);
                });
                it('should return that default document orientation is set to portrait mode', function () {
                    expect(pageLayout.getPageAttribute('orientation')).to.equal('portrait');
                    expect(pageLayout.getPageAttribute('orientation')).not.to.equal('landscape');
                });
            });

            describe('method "getNumberOfDocumentPages"', function () {
                it('should exist', function () {
                    expect(pageLayout).to.respondTo('getNumberOfDocumentPages');
                });
                it('should return correct number of document pages', function () {
                    expect(pageLayout.getNumberOfDocumentPages()).to.equal(3);
                });
            });

        });

    });

    // ========================================================================
});
