/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/utils/errorcode',
    'io.ox/office/spreadsheet/model/formula/formulacontext',
    'io.ox/office/spreadsheet/model/formula/impl/statisticalfuncs'
], function (ErrorCode, FormulaContext, StatisticalFuncs) {

    'use strict';

    // initialize the formula context
    var context = null;
    before(function (done) {
        ox.test.spreadsheet.createApp('ooxml').done(function (app) {
            context = new FormulaContext(app.getModel());
            done();
        });
    });

    // module StatisticalFuncs ================================================

    describe('Spreadsheet module StatisticalFuncs', function () {

        it('should exist', function () {
            expect(StatisticalFuncs).to.be.an('object');
        });

        // function implementations -------------------------------------------

        describe('function "PERMUT"', function () {
            var PERMUT = StatisticalFuncs.PERMUT;
            it('should exist', function () {
                expect(PERMUT).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(PERMUT).itself.to.respondTo('resolve');
            });
            it('should return the permutation of assigned integers', function () {
                expect(PERMUT.resolve.call(context, 100, 3)).to.equal(970200);
                expect(PERMUT.resolve.call(context, 3, 2)).to.almostEqual(6);

                expect(PERMUT.resolve.bind(context, 0, 1)).to['throw'](ErrorCode).that.equals(ErrorCode.NUM);
                expect(PERMUT.resolve.bind(context, 2, -1)).to['throw'](ErrorCode).that.equals(ErrorCode.NUM);
                expect(PERMUT.resolve.bind(context, 1, 2)).to['throw'](ErrorCode).that.equals(ErrorCode.NUM);
            });
        });

        describe('function "PERMUTATIONA"', function () {
            var PERMUTATIONA = StatisticalFuncs.PERMUTATIONA;
            it('should exist', function () {
                expect(PERMUTATIONA).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(PERMUTATIONA).itself.to.respondTo('resolve');
            });
            it('should return the permutation of assigned integers', function () {
                expect(PERMUTATIONA.resolve.call(context, 4, 3)).to.equal(64);
                expect(PERMUTATIONA.resolve.call(context, 0, 0)).to.almostEqual(1);

                expect(PERMUTATIONA.resolve.bind(context, -1, 1)).to['throw'](ErrorCode).that.equals(ErrorCode.NUM);
                expect(PERMUTATIONA.resolve.bind(context, 1, -1)).to['throw'](ErrorCode).that.equals(ErrorCode.NUM);
                expect(PERMUTATIONA.resolve.bind(context, -1, -1)).to['throw'](ErrorCode).that.equals(ErrorCode.NUM);
            });
        });

    });

    // ========================================================================
});
