/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/text/model/model', [
    'io.ox/office/textframework/model/editor',
    'io.ox/office/text/model/modelattributesmixin',
    'io.ox/office/text/format/listcollection',
    'io.ox/office/text/format/stylesheetmixin',
    'io.ox/office/text/model/pagehandlermixin',
    'io.ox/office/text/model/updatedocumentmixin',
    'io.ox/office/text/model/listhandlermixin',
    'io.ox/office/text/model/updatelistsmixin',
    'io.ox/office/text/components/drawing/drawingresize'
], function (Editor, ModelAttributesMixin, ListCollection, StylesheetMixin, PageHandlerMixin, UpdateDocumentMixin, ListHandlerMixin, UpdateListsMixin, DrawingResize) {

    'use strict';

    // class TextModel ================================================

    /**
     * Represents the document model of a text application.
     *
     * @constructor
     *
     * @extends Editor
     * @extends ModelAttributesMixin
     * @extends StylesheetMixin
     * @extends PageHandlerMixin
     * @extends UpdateDocumentMixin
     * @extends ListHandlerMixin
     * @extends UpdateListsMixin
     *
     * @param {TextApplication} app
     *  The application containing this document model.
     */
    function TextModel(app) {

        var // self reference for local functions
            self = this,
            // the root element for the document contents
            pagediv = null;

        // base constructor ---------------------------------------------------

        Editor.call(this, app);
        ModelAttributesMixin.call(this);
        StylesheetMixin.call(this, app);
        PageHandlerMixin.call(this, app);
        UpdateDocumentMixin.call(this, app);
        ListHandlerMixin.call(this);
        UpdateListsMixin.call(this, app);

        // private methods ----------------------------------------------------

        // public methods -----------------------------------------------------

        // initialization -----------------------------------------------------

        pagediv = self.getNode();

        // the textmodel.js has an own drawing style object with own format handler -> that need to be overwritten
        self.setCharacterStyles(self.getStyleCollection('character'));
        self.setParagraphStyles(self.getStyleCollection('paragraph'));
        self.setDrawingStyles(self.getStyleCollection('drawing'));
        self.setTableStyles(self.getStyleCollection('table'));
        self.setTableRowStyles(self.getStyleCollection('row'));
        self.setTableCellStyles(self.getStyleCollection('cell'));
        self.setPageStyles(self.getStyleCollection('page'));

        // setting the handler function for moving and resizing drawings
        self.getSelection().setDrawingResizeHandler(DrawingResize.drawDrawingSelection);

        // setting the handler function for updating lists (this is used during 'updateDocumentFormatting')
        self.setUpdateLists(self.getUpdateListsHandler());

        // setting the list collection object
        self.setListCollection(new ListCollection(this));

        // setting the handler function for updating lists after the document is imported successfully
        self.waitForImportSuccess(function () {
            self.setUpdateListsDebounced(self.getDebouncedUpdateListsHandler());
        });

        // registering process mouse down handler at the page
        pagediv.on({ 'mousedown touchstart': self.getPageProcessMouseDownHandler() });
        if (self.getListenerList()) { self.getListenerList()['mousedown touchstart'] = self.getPageProcessMouseDownHandler(); }

    } // class TextModel

    // constants --------------------------------------------------------------

    // exports ================================================================

    // derive this class from class Editor
    return Editor.extend({ constructor: TextModel });

});
