/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/gridlinemodel', [
    'io.ox/office/editframework/model/attributedmodel',
    'io.ox/office/drawinglayer/view/chartstyleutil'
], function (AttributedModel, ChartStyleUtil) {

    'use strict';

    // class GridlineModel ====================================================

    /**
     * visualization model for chart axes,
     * it defines colors and textual colors
     *
     * @constructor
     *
     * @extends AttributedModel
     */
    function GridlineModel(chartModel, attrs, dataAxis) {

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chartModel.getDocModel(), attrs, { families: 'line' });

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            var att = this.getMergedAttributes();
            if (!dataAxis) {
                return;
            }

            ChartStyleUtil.handleLineProps(chartModel, att.line, dataAxis, 'grid');
        };

    } // class GridlineModel

    // exports ================================================================

    return AttributedModel.extend({ constructor: GridlineModel });

});
