/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/imagemodel', [
    'io.ox/office/editframework/utils/border',
    'io.ox/office/drawinglayer/model/drawingmodel'
], function (Border, DrawingModel) {

    'use strict';

    // class ImageModel =======================================================

    /**
     * The model of a image/picture object.
     *
     * @constructor
     *
     * @extends DrawingModel
     *
     * @param {EditModel} docModel
     *  The document model containing this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    function ImageModel(docModel, initAttributes) {

        // base constructor ---------------------------------------------------

        DrawingModel.call(this, docModel, 'image', initAttributes, { families: 'image fill line' });

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docModel = initAttributes = null;
        });

    } // class ImageModel

    // exports ================================================================

    // derive this class from class DrawingModel
    return DrawingModel.extend({ constructor: ImageModel });

});
