/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/viewobjectmixin', function () {

    'use strict';

    // mix-in class ViewObjectMixin ===========================================

    /**
     * A mix-in class intended to be included in various view-related classes,
     * providing convenience methods for the internal class implementation, and
     * a few generic public methods.
     *
     * @constructor
     *
     * @param {BaseView} docView
     *  The document view instance containing the view object extended with
     *  this mix-in class.
     */
    function ViewObjectMixin(docView) {

        // protected methods --------------------------------------------------

        /**
         * Registers an event listener for the controller event 'change:items',
         * and invokes the passed callback function on every event. Provided as
         * a convenience shortcut that can even be used during construction
         * time of the view when the controller is not available yet.
         *
         * @param {Function} callback
         *  The callback to be invoked on every controller change event. Will
         *  be invoked in the context of this instance.
         *
         * @param {Object} [context]
         *  The context bound to the invoked callback function.
         *
         * @returns {ViewObjectMixin}
         *  A reference to this instance.
         */
        this.handleChangedControllerItems = function (callback, context) {
            docView.getApp().onInit(function () {
                this.listenTo(docView.getApp().getController(), 'change:items', function (event, changedItems) {
                    return callback.call(context, changedItems);
                });
            }, this);
            return this;
        };

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = null;
        });

    } // mix-in class ViewObjectMixin

    // exports ================================================================

    return ViewObjectMixin;

});
