/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Carsten Driesner <carsten.driesner@open-xchange.com>
 */

define('io.ox/office/baseframework/utils/infostate', function () {

    'use strict';

    // static class InfoState =================================================

    var
        InfoState = {};

    // constants --------------------------------------------------------------

    // the constant info state codes
    InfoState.INFO_SYNCHRONIZATION_SUCCESSFUL      = 'INFO_SYNCHRONIZATION_SUCCESSFUL';
    InfoState.INFO_EDITRIGHTS_ARE_TRANSFERED       = 'INFO_EDITRIGHTS_ARE_TRANSFERED';
    InfoState.INFO_EDITRIGHTS_SAVE_IN_PROGRESS     = 'INFO_EDITRIGHTS_SAVE_IN_PROGRESS';
    InfoState.INFO_EDITRIGHTS_PLEASE_WAIT          = 'INFO_EDITRIGHTS_PLEASE_WAIT';
    InfoState.INFO_ALREADY_TRANSFERING_EDIT_RIGHTS = 'INFO_ALREADY_TRANSFERING_EDIT_RIGHTS';
    InfoState.INFO_CONNECTION_WAS_LOST_TRYING_SYNC = 'INFO_CONNECTION_WAS_LOST_TRYING_SYNC';
    InfoState.INFO_CONNECTION_WAS_LOST             = 'INFO_CONNECTION_WAS_LOST';
    InfoState.INFO_CONNECTION_LOST_RELOAD_DOC      = 'INFO_CONNECTION_LOST_RELOAD_DOC';
    InfoState.INFO_NO_PERMISSION_TO_CHANGE_DOC     = 'INFO_NO_PERMISSION_TO_CHANGE_DOC';
    InfoState.INFO_PREPARE_LOSING_EDIT_RIGHTS      = 'INFO_PREPARE_LOSING_EDIT_RIGHTS';
    InfoState.INFO_USER_IS_CURRENTLY_EDIT_DOC      = 'INFO_USER_IS_CURRENTLY_EDIT_DOC';
    InfoState.INFO_EDITRIGHTS_RECEIVED             = 'INFO_EDITRIGHTS_RECEIVED';
    InfoState.INFO_DOC_CONVERT_STORED_IN_DEFFOLDER = 'INFO_DOC_CONVERT_STORED_IN_DEFFOLDER';
    InfoState.INFO_DOC_CONVERTED_AND_STORED        = 'INFO_DOC_CONVERTED_AND_STORED';
    InfoState.INFO_DOC_CREATED_IN_DEFAULTFOLDER    = 'INFO_DOC_CREATED_IN_DEFAULTFOLDER';
    InfoState.INFO_LOADING_IN_PROGRESS             = 'INFO_LOADING_IN_PROGRESS';
    InfoState.INFO_DOC_SAVED_AS_TEMPLATE           = 'INFO_DOC_SAVED_AS_TEMPLATE';
    InfoState.INFO_DOC_RESCUED_SUCCESSFULLY        = 'INFO_DOC_RESCUED_SUCCESSFULLY';
    InfoState.INFO_DOC_SAVE_FAILED                 = 'INFO_DOC_SAVE_FAILED';
    InfoState.INFO_SYNCHRONIZATION_FAILED          = 'INFO_SYNCHRONIZATION_FAILED';

    // exports ================================================================

    return InfoState;

});
