/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/utils/errorcode',
    'io.ox/office/spreadsheet/model/formula/formulacontext',
    'io.ox/office/spreadsheet/model/formula/impl/informationfuncs'
], function (ErrorCode, FormulaContext, InformationFuncs) {

    'use strict';

    // initialize the formula context
    var context = null;
    before(function (done) {
        ox.test.spreadsheet.createApp('ooxml').done(function (app) {
            context = new FormulaContext(app.getModel());
            done();
        });
    });

    // module InformationFuncs ================================================

    describe('Spreadsheet module InformationFuncs', function () {

        it('should exist', function () {
            expect(InformationFuncs).to.be.an('object');
        });

        // function implementations -------------------------------------------

        describe('function "ERROR.TYPE"', function () {
            var ERROR_TYPE = InformationFuncs['ERROR.TYPE'];
            it('should exist', function () {
                expect(ERROR_TYPE).to.be.an('object');
            });
            it('should be implemented', function () {
                expect(ERROR_TYPE).itself.to.respondTo('resolve');
            });

            it('should return the sum of a power series', function () {
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.NULL)).to.equal(1);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.DIV0)).to.equal(2);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.VALUE)).to.equal(3);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.REF)).to.equal(4);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.NAME)).to.equal(5);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.NUM)).to.equal(6);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.NA)).to.equal(7);
                expect(ERROR_TYPE.resolve.call(context, ErrorCode.DATA)).to.equal(8);

                expect(ERROR_TYPE.resolve.bind(context, 'hello')).to['throw'](ErrorCode).that.equals(ErrorCode.NA);
            });
        });
    });

    // ========================================================================
});
