/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define([
    'io.ox/office/presentation/model/listhandlermixin',
    'io.ox/office/editframework/utils/attributeutils',
    'io.ox/office/textframework/utils/dom'
], function (ListHandlerMixin, AttributeUtils, DOM) {

    'use strict';

    // mix-in class UpdateListsMixin ==========================================

    describe('Presentation mix-in class ListHandlerMixin', function () {

        // private helpers ----------------------------------------------------

        var model = null,
            view = null,
            layoutId_1 = 'layout1',
            masterId_1 = 'master1',
            slideDefaultName = 'slide_1',
            firstStandardDrawing = null, // the first drawing in the standard slide
            firstStandardParagraphs = null, // the paragraphs in the first drawing in the standard slide
            secondStandardDrawing = null, // the second drawing in the standard slide
            secondStandardParagraphs = null, // the paragraphs in the second drawing in the standard slide
            explicitAttributes = null,  // the explicit attributes of a paragraph

            // the operations to be applied by the document model
            OPERATIONS = [
                {
                    name: 'setDocumentAttributes',
                    attrs: {
                        page: { width: 33866, height: 19050, orientation: 'landscape' },
                        defaultTextListStyles: {
                            l1: { character: { fontSize: 18, fontName: '+mn-lt', color: { type: 'scheme', value: 'text1' } }, paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 0 } },
                            l2: { character: { fontSize: 18, fontName: '+mn-lt', color: { type: 'scheme', value: 'text1' } }, paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 1270 } },
                            l3: { character: { fontSize: 18, fontName: '+mn-lt', color: { type: 'scheme', value: 'text1' } }, paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 2540 } }
                        }
                    }
                },
                { name: 'insertMasterSlide', id: masterId_1, attrs:
                    { listStyles: {
                        title: { l1: {
                            character: { fontSize: 44, fontName: '+mj-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                            paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'percent', value: 0 }, defaultTabSize: 2540, bullet: { type: 'none' }, alignment: 'left' } }
                        },
                        body: {
                            l1: {
                                character: { fontSize: 28, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 35 }, defaultTabSize: 2540, bullet: { type: 'character', character: '-' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 635, indentFirstLine: -634 }
                            },
                            l2: {
                                character: { fontSize: 24, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 1905, indentFirstLine: -634 }
                            },
                            l3: {
                                character: { fontSize: 20, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 3175, indentFirstLine: -634 }
                            },
                            l4: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 4445, indentFirstLine: -634 }
                            },
                            l5: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 5715, indentFirstLine: -634 }
                            },
                            l6: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 6985, indentFirstLine: -634 }
                            },
                            l7: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 8255, indentFirstLine: -634 }
                            },
                            l8: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 9525, indentFirstLine: -634 }
                            },
                            l9: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { lineHeight: { type: 'percent', value: 90 }, spacingBefore: { type: 'fixed', value: 17 }, defaultTabSize: 2540, bullet: { type: 'character', character: '•' }, bulletFont: { followText: false, name: 'Arial' }, alignment: 'left', indentLeft: 10795, indentFirstLine: -634 }
                            }
                        },
                        other: {
                            l1: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 0 }
                            },
                            l2: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 1270 }
                            },
                            l3: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 2540 }
                            },
                            l4: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 3810 }
                            },
                            l5: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 5080 }
                            },
                            l6: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 6350 }
                            },
                            l7: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 7620 }
                            },
                            l8: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 8890 }
                            },
                            l9: {
                                character: { fontSize: 18, fontName: '+mn-lt', type: 'solid', color: { type: 'scheme', value: 'text1' } },
                                paragraph: { defaultTabSize: 2540, alignment: 'left', indentLeft: 10160 }
                            }
                        }
                    }
                } },
//                { name: 'insertTheme', themeName: 'Office', target: masterId_1, attrs: { colorScheme: { dark1: '000000', dark2: '44546a', light1: 'ffffff', light2: 'e7e6e6', text1: '000000', text2: '44546a', background1: 'ffffff', background2: 'e7e6e6', accent1: '5b9bd5', accent2: 'ed7d31', accent3: 'a5a5a5', accent4: 'ffc000', accent5: '4472c4', accent6: '70ad47', hyperlink: '0563c1', followedHyperlink: '954f72' }}},
//                { name: 'insertDrawing', start: [0, 0], target: masterId_1, type: 'shape', attrs: { presentation: { phType: 'title' }, shape: { anchor: 'centered', paddingLeft: 254, paddingRight: 254, paddingTop: 127, paddingBottom: 127 }, drawing: { name: 'T1', left: 2328, top: 1014, width: 29210, height: 3682 }, geometry: { presetShape: 'rect', avList: {} }}},
//                { name: 'insertParagraph', start: [0, 0, 0], target: masterId_1 },
//                { name: 'insertText', start: [0, 0, 0, 0], target: masterId_1, text: 'Master title format' },
//                { name: 'insertDrawing', start: [0, 1], target: masterId_1, type: 'shape', attrs: { presentation: { phType: 'body', phIndex: 1 }, drawing: { name: 'T2', left: 2328, top: 5071, width: 29210, height: 12087 }, geometry: { presetShape: 'rect', avList: {} }}},
//                { name: 'insertParagraph', start: [0, 1, 0], target: masterId_1, attrs: { paragraph: { level: 0 }}},
//                { name: 'insertText', start: [0, 1, 0, 0], target: masterId_1,text: 'Format templates' },
//                { name: 'insertParagraph', start: [0, 1, 1], target: masterId_1, attrs: { paragraph: { level: 1 }}},
//                { name: 'insertText', start: [0, 1, 1, 0], target: masterId_1,text: 'Second level' },
//                { name: 'insertParagraph', start: [0, 1, 2], target: masterId_1, attrs: { paragraph: { level: 2 }}},
//                { name: 'insertText', start: [0, 1, 2, 0], target: masterId_1,text: 'Third level' },
//                { name: 'insertParagraph', start: [0, 1, 3], target: masterId_1, attrs: { paragraph: { level: 3 }}},
//                { name: 'insertText', start: [0, 1, 3, 0], target: masterId_1, text: 'Fourth level' },
//                { name: 'insertParagraph', start: [0, 1, 4], target: masterId_1, attrs: { paragraph: { level: 4 }}},
//                { name: 'insertText', start: [0, 1, 4, 0], target: masterId_1, text: 'Fifth level' },
//                { name: 'insertDrawing', start: [0, 2],target: masterId_1, type: 'shape', attrs: { presentation: { phType: 'dt', phSize: 'half', phIndex: 2 }, listStyle: { l1: { character: { fontSize: 12, type: 'solid', color: { type: 'scheme', value: 'text1', transformations: [{ type: 'tint', value: 75000 }] }}, paragraph: { alignment: 'left' }}}, shape: { anchor: 'centered', paddingLeft: 254, paddingRight: 254, paddingTop: 127, paddingBottom: 127 }, drawing: { name: 'D3', left: 2328, top: 17657, width: 7620, height: 1014 }, geometry: { presetShape: 'rect', avList: {} }}},
//                { name: 'insertParagraph', start: [0, 2, 0], target: masterId_1 },
//                { name: 'insertDrawing', start: [0, 3], target: masterId_1, type: 'shape', attrs: { presentation: { phType: 'ftr', phSize: 'quarter', phIndex: 3 }, listStyle: { l1: { character: { fontSize: 12, type: 'solid', color: { type: 'scheme', value: 't1', transformations: [{ type: 'tint', value: 75000 }] }}, paragraph: { alignment: 'center' }}}, shape: { anchor: 'centered', paddingLeft: 254, paddingRight: 254, paddingTop: 127, paddingBottom: 127 }, drawing: { name: 'F4', left: 11218, top: 17657, width: 11430, height: 1014 }, geometry: { presetShape: 'rect', avList: {} }}},
//                { name: 'insertParagraph', start: [0, 3, 0], target: masterId_1 },
//                { name: 'insertDrawing', start: [0, 4], target: masterId_1, type: 'shape', attrs: { presentation: { phType: 'sldNum', phSize: 'quarter', phIndex: 4 }, listStyle: { l1: { character: { fontSize: 12, type: 'solid', color: { type: 'scheme', value: 't1', transformations: [{ type: 'tint', value: 75000 }] }}, paragraph: { alignment: 'right' }}}, shape: { anchor: 'centered', paddingLeft: 254, paddingRight: 254, paddingTop: 127, paddingBottom: 127 }, drawing: { name: 'F5', left: 23918, top: 17657, width: 7620, height: 1014 }, geometry: { presetShape: 'rect', avList: {} }}},
//                { name: 'insertParagraph', start: [0, 4, 0], target: masterId_1 },
                { name: 'insertLayoutSlide', id: layoutId_1, target: masterId_1 },
//                { name: 'insertDrawing', start: [0, 0], target: layoutId_1, type: 'shape', attrs: { presentation: { phType: 'title' }, drawing: { name: 'Title 1' }}},
//                { name: 'insertParagraph', start: [0, 0, 0], target: layoutId_1 },
//                { name: 'insertText', start: [0, 0, 0, 0], target: layoutId_1, text: 'Title master format' },
//                { name: 'insertDrawing', start: [0, 1], target: layoutId_1, type: 'shape', attrs: { presentation: { phIndex: 1 }, drawing: { name: 'I2' }}},
//                { name: 'insertParagraph', start: [0, 1, 0], target: layoutId_1, attrs: { paragraph: { level: 0 }}},
//                { name: 'insertText', start: [0, 1, 0, 0], target: layoutId_1, text: 'Format templates' },
//                { name: 'insertParagraph', start: [0, 1, 1], target: layoutId_1, attrs: { paragraph: { level: 1 }}},
//                { name: 'insertText', start: [0, 1, 1, 0], target: layoutId_1, text: 'Second level' },
//                { name: 'insertParagraph', start: [0, 1, 2], target: layoutId_1, attrs: { paragraph: { level: 2 }}},
//                { name: 'insertText', start: [0, 1, 2, 0], target: layoutId_1, text: 'Third level' },
//                { name: 'insertParagraph', start: [0, 1, 3], target: layoutId_1, attrs: { paragraph: { level: 3 }}},
//                { name: 'insertText', start: [0, 1, 3, 0], target: layoutId_1, text: 'Fourth level' },
//                { name: 'insertParagraph', start: [0, 1, 4], target: layoutId_1, attrs: { paragraph: { level: 4 }}},
//                { name: 'insertText', start: [0, 1, 4, 0], target: layoutId_1, text: 'Fifth level' },
                { name: 'insertDrawing', start: [0, 2], target: layoutId_1, type: 'shape', attrs: { presentation: { phType: 'dt', phSize: 'half', phIndex: 10 }, drawing: { name: 'D3' } } },
                { name: 'insertParagraph', start: [0, 2, 0], target: layoutId_1 },
                { name: 'insertDrawing', start: [0, 3], target: layoutId_1, type: 'shape', attrs: { presentation: { phType: 'ftr', phSize: 'quarter', phIndex: 11 }, drawing: { name: 'F4' } } },
                { name: 'insertParagraph', start: [0, 3, 0], target: layoutId_1 },
                { name: 'insertDrawing', start: [0, 4], target: layoutId_1, type: 'shape', attrs: { presentation: { phType: 'sldNum', phSize: 'quarter', phIndex: 12 }, drawing: { name: 'F5' } } },
                { name: 'insertParagraph', start: [0, 4, 0], target: layoutId_1 },
                { name: 'insertSlide', start: 0, target: layoutId_1 },
                { name: 'insertDrawing', start: [0, 0], type: 'shape', attrs: { presentation: { phType: 'title' }, drawing: { name: 'Title 1' } } },
                { name: 'insertParagraph', start: [0, 0, 0] },
                { name: 'insertText', start: [0, 0, 0, 0], text: 'Title' },
                { name: 'insertDrawing', start: [0, 1], type: 'shape', attrs: { presentation: { phIndex: 1 }, drawing: { name: 'I2' } } },
                { name: 'insertParagraph', start: [0, 1, 0] },
                { name: 'insertText', start: [0, 1, 0, 0], text: 'Item 1' },
                { name: 'insertParagraph', start: [0, 1, 1] },
                { name: 'insertText', start: [0, 1, 1, 0], text: 'Item 2' },
//                { name: 'insertParagraph', start: [0, 1, 2] },
//                { name: 'insertText', start: [0, 1, 2, 0],text: 'Item 3' },
//                { name: 'insertParagraph', start: [0, 1, 3] },
//                { name: 'insertText', start: [0, 1, 3, 0],text: 'Item 4' },
//                { name: 'insertParagraph', start: [0, 1, 4] },
//                { name: 'insertText', start: [0, 1, 4, 0],text: 'Item 5' },
//                { name: 'insertParagraph', start: [0, 1, 5] },
//                { name: 'insertText', start: [0, 1, 5, 0],text: 'Item 6' }
                { name: 'insertDrawing', attrs: { drawing: { width: 8000, left: 5000, top: 3000 }, shape: { autoResizeHeight: true }, line: { color: { type: 'rgb', value: '000000' }, style: 'single', type: 'none', width: 26 }, fill: { color: { type: 'auto' }, type: 'solid' } }, start: [0, 2], type: 'shape' },
                { name: 'insertParagraph', start: [0, 2, 0] },
                { name: 'insertText', start: [0, 2, 0, 0], text: 'Text frame text' }
            ];

        before(function (done) {
            ox.test.presentation.createApp('ooxml', OPERATIONS).done(function (app) {
                app.isOperationsBlockActive = function () {};
                model = app.getModel();
                model.leaveAsyncBusy = function () {};
                view = app.getView();
                view.clearVisibleDrawingAnchor = function () {};
                view.isSearchActive = function () {};
                view.enterBusy = function () {};
                done();
            });
        });

        // existence check ----------------------------------------------------

        it('should exist', function () {
            expect(ListHandlerMixin).to.be.a('function');
        });

        // public methods -----------------------------------------------------

        describe('method "isStandardSlideId"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('isStandardSlideId');
            });
            it('should return whether the specified ID is the ID of a normal (standard) slide', function () {
                expect(model.isStandardSlideId(layoutId_1)).to.equal(false);
                expect(model.isStandardSlideId(masterId_1)).to.equal(false);
                expect(model.isStandardSlideId(slideDefaultName)).to.equal(true);
            });
        });

        describe('method "getActiveSlideId"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('getActiveSlideId');
            });
            it('should return the ID of the active slide', function () {
                expect(model.getActiveSlideId()).to.equal(slideDefaultName);
            });
        });

        describe('method "DOM.isListParagraphNode"', function () {
            it('should exist', function () {
                expect(DOM).to.respondTo('isListParagraphNode');
            });
            it('should check whether the specified node is a list paragraph', function () {
                model.getSelection().setTextSelection([0, 0, 0, 0]);
                firstStandardDrawing = model.getSelection().getSelectedTextFrameDrawing();
                expect(firstStandardDrawing.length).to.equal(1);
                firstStandardParagraphs = firstStandardDrawing.find(DOM.PARAGRAPH_NODE_SELECTOR);
                expect(firstStandardParagraphs.length).to.equal(1);
                model.getSelection().setTextSelection([0, 1, 0, 0]);
                secondStandardDrawing = model.getSelection().getSelectedTextFrameDrawing();
                expect(secondStandardDrawing.length).to.equal(1);
                secondStandardParagraphs = secondStandardDrawing.find(DOM.PARAGRAPH_NODE_SELECTOR);
                expect(secondStandardParagraphs.length).to.equal(2);
                expect(DOM.isListParagraphNode(firstStandardParagraphs)).to.equal(true);
                expect(DOM.isListParagraphNode(secondStandardParagraphs[0])).to.equal(true);
            });
        });

        describe('method "DOM.isListLabelNode"', function () {
            it('should exist', function () {
                expect(DOM).to.respondTo('isListLabelNode');
            });
            it('should check whether the specified node is a list label in a list paragraph', function () {
                expect(DOM.isListLabelNode(firstStandardParagraphs[0].childNodes[0])).to.equal(true);
                expect(DOM.isListLabelNode(secondStandardParagraphs[0].childNodes[0])).to.equal(true);
            });
        });

        describe('method "isListIndentChangeable"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('isListIndentChangeable');
            });
            it('should check whether the list level at the currently selected paragraph is changeable', function () {
                model.getSelection().setTextSelection([0, 0, 0, 0]);
                expect(model.isListIndentChangeable()).to.equal(false);
                model.getSelection().setTextSelection([0, 1, 0, 0]);
                expect(model.isListIndentChangeable()).to.equal(true);
            });
        });

        describe('method "getMaxListLevel"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('getMaxListLevel');
            });
            it('should receive the maximum list level for the drawing that contains the selection', function () {
                model.getSelection().setTextSelection([0, 0, 0, 0]);
                expect(model.getMaxListLevel()).to.equal(0);
                model.getSelection().setTextSelection([0, 1, 0, 0]);
                expect(model.getMaxListLevel()).to.equal(8);
            });
        });

        describe('method "changeListIndent"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('changeListIndent');
            });
            it('should change the level of list indent for the specified paragraph', function () {

                expect(firstStandardParagraphs[0].childNodes.length).to.equal(2);
                expect($(firstStandardParagraphs[0].childNodes[0]).text()).to.equal('');
                expect($(firstStandardParagraphs[0].childNodes[1]).text()).to.equal('Title');

                expect(secondStandardParagraphs[0].childNodes.length).to.equal(2);
                expect($(secondStandardParagraphs[0].childNodes[0]).text()).to.equal('-');
                expect($(secondStandardParagraphs[0].childNodes[1]).text()).to.equal('Item 1');

                model.getSelection().setTextSelection([0, 0, 0, 0]);

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph).to.be.undefined;

                model.changeListIndent(); // increasing indent of first paragraph

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph).to.be.undefined;  // no effect in title

                model.changeListIndent({ increase: false }); // decreasing indent of first paragraph

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph).to.be.undefined;  // no effect in title

                model.getSelection().setTextSelection([0, 1, 0, 0]);

                model.changeListIndent(); // increasing indent of first paragraph

                explicitAttributes = AttributeUtils.getExplicitAttributes(secondStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.level).to.equal(1);

                model.changeListIndent(); // increasing indent of first paragraph

                explicitAttributes = AttributeUtils.getExplicitAttributes(secondStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.level).to.equal(2);

                model.changeListIndent({ increase: false }); // decreasing indent of first paragraph

                explicitAttributes = AttributeUtils.getExplicitAttributes(secondStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.level).to.equal(1);

            });
        });

        describe('method "setListStyleId"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('setListStyleId');
            });
            it('should set the specified list style to the selected paragraph', function () {

                model.getSelection().setTextSelection([0, 0, 0, 0]);

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph).to.be.undefined;

                model.setListStyleId('bullet', ListHandlerMixin.DEFAULT_VALUE, '');

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.bullet.type).to.equal('character');

                model.setListStyleId('bullet', ListHandlerMixin.DEFAULT_VALUE, ListHandlerMixin.DEFAULT_BULLET_LISTSTYLE);

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.bullet.type).to.equal('none');
            });
        });

        describe('method "getListStyleId"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('getListStyleId');
            });
            it('should get the list style to a selected paragraph', function () {

                var newListStyleId = 'L20014';

                model.getSelection().setTextSelection([0, 0, 0, 0]);

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.bullet.type).to.equal('none');

                model.setListStyleId('bullet', newListStyleId, '');

                explicitAttributes = AttributeUtils.getExplicitAttributes(firstStandardParagraphs[0]);
                expect(explicitAttributes.paragraph.bullet.type).to.equal('character');

                expect(model.getListStyleId('bullet', explicitAttributes.paragraph)).to.equal(newListStyleId);
            });
        });

        describe('method "getMaxListLevel"', function () {
            it('should receive the maximum list level of a paragraph inside a text frame', function () {
                model.getSelection().setTextSelection([0, 2, 0, 0]);
                expect(model.getMaxListLevel()).to.equal(2);
            });
        });

    });

    // ========================================================================
});
