/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/editframework/utils/operations'
], function (Operations) {

    'use strict';

    // static class Operations ================================================

    describe('EditFramework module Operations', function () {

        it('should exist', function () {
            expect(Operations).to.be.an('object');
        });

        // private helpers ----------------------------------------------------

        function checkOperationName(propertyName, operationName) {
            it('"' + propertyName + '" should exist', function () {
                expect(Operations[propertyName]).to.equal(operationName);
            });
        }

        // constants ----------------------------------------------------------

        describe('constant', function () {
            checkOperationName('SET_DOCUMENT_ATTRIBUTES', 'setDocumentAttributes');
            checkOperationName('INSERT_THEME', 'insertTheme');
            checkOperationName('INSERT_FONT_DESCRIPTION', 'insertFontDescription');
            checkOperationName('INSERT_STYLESHEET', 'insertStyleSheet');
            checkOperationName('DELETE_STYLESHEET', 'deleteStyleSheet');
            checkOperationName('NOOP', 'noOp');
        });
    });

    // ========================================================================
});
