/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/drawinglayer/utils/operations'
], function (DrawingOperations) {

    'use strict';

    // static class DrawingOperations =========================================

    describe('DrawingLayer module DrawingOperations', function () {

        it('should exist', function () {
            expect(DrawingOperations).to.be.an('object');
        });

        // private helpers ----------------------------------------------------

        function checkOperationName(propertyName, operationName) {
            it('"' + propertyName + '" should exist', function () {
                expect(DrawingOperations[propertyName]).to.equal(operationName);
            });
        }

        // constants ----------------------------------------------------------

        describe('constant', function () {
            checkOperationName('INSERT_DRAWING', 'insertDrawing');
            checkOperationName('DELETE_DRAWING', 'deleteDrawing');
            checkOperationName('SET_DRAWING_ATTRIBUTES', 'setDrawingAttributes');
            checkOperationName('INSERT_CHART_DATASERIES', 'insertChartDataSeries');
            checkOperationName('DELETE_CHART_DATASERIES', 'deleteChartDataSeries');
            checkOperationName('SET_CHART_DATASERIES_ATTRIBUTES', 'setChartDataSeriesAttributes');
            checkOperationName('SET_CHART_AXIS_ATTRIBUTES', 'setChartAxisAttributes');
            checkOperationName('SET_CHART_GRIDLINE_ATTRIBUTES', 'setChartGridlineAttributes');
            checkOperationName('SET_CHART_TITLE_ATTRIBUTES', 'setChartTitleAttributes');
            checkOperationName('SET_CHART_LEGEND_ATTRIBUTES', 'setChartLegendAttributes');
        });
    });

    // ========================================================================
});
