/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    var fs = require('fs');
    var path = require('path');

    // helper functions =======================================================

    /**
     * Returns whether the file with the specified name is newer than the time
     * stamp.
     */
    function isNewer(file, mTime) {
        return fs.existsSync(file) && fs.statSync(file).mtime > mTime;
    }

    /**
     * Returns whether any of the implicit LESS dependencies is newer than the
     * passed time stamp.
     */
    function hasNewerImplicitImports(mTime, theme) {
        return ['lib/appsuite/apps/themes/mixins.less', 'lib/appsuite/apps/themes/definitions.less', path.join('apps/themes/', theme, 'definitions.less')]
            .some(function (lessFile) { return isNewer(lessFile, mTime); });
    }

    /**
     * Returns whether any of the explicit LESS dependencies is newer than the
     * passed time stamp.
     */
    function hasNewerExplicitImports(lessFile, mTime) {

        // regular expression matching @import statements in LESS files
        var regex = /@import +['"](.+?)(?:\.less)?['"];/g;

        // directory part of the checked LESS file
        var lessDir = path.dirname(lessFile);

        // read the entire LESS file
        var data = grunt.file.read(lessFile);

        // process all @import statements in the LESS file
        var match;
        while ((match = regex.exec(data))) {
            var importFile = path.join(lessDir, match[1] + '.less');
            // return true, if the imported file is newer, or if it imports newer files
            if (isNewer(importFile, mTime) || hasNewerExplicitImports(importFile, mTime)) { return true; }
        }
        return false;
    }

    /**
     * Returns whether any of the implicit or explicit LESS dependencies is
     * newer than the passed time stamp.
     */
    function hasNewerImports(lessFile, mTime, theme) {
        return hasNewerImplicitImports(mTime, theme) || hasNewerExplicitImports(lessFile, mTime);
    }

    // build task =============================================================

    grunt.config.extend('newer', {
        options: {
            cache: 'build/.newer-cache',
            override: function (detail, include) {
                // call include() callback with value true, if there are newer imports for a LESS file
                include((detail.task === 'less') && hasNewerImports(detail.path, detail.time, detail.target));
            }
        }
    });

    grunt.loadNpmTasks('grunt-newer');
};
