/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/textframework/view/control/changetrackbadge', [
    'io.ox/office/tk/utils',
    'io.ox/office/baseframework/utils/errorcode',
    'io.ox/office/baseframework/view/control/userpicture',
    'io.ox/office/textframework/view/labels',
    'io.ox/office/tk/utils/driveutils',
    'gettext!io.ox/office/textframework/main'
], function (Utils, ErrorCode, UserPicture, Labels, DriveUtils, gt) {

    'use strict';

    // class ChangeTrackBadge =================================================

    /**
     * Drop-down menu control for position and text floating of drawing
     * objects in text documents.
     *
     * @constructor
     *
     * @extends UserPicture
     */
    function ChangeTrackBadge(docView, initOptions) {

        var // self reference
            self = this,

            authorLinkNode = $('<a>').addClass('change-track-author').text(gt('Unknown')),
            dateNode = $('<div>').addClass('change-track-date').text(gt('Unknown')),
            actionNode = $('<div>').addClass('change-track-action').text(gt('Unknown')),
            descriptionNode = $('<div>').addClass('change-track-description');

        // base constructor ---------------------------------------------------

        UserPicture.call(this, null, initOptions);

        // public methods -----------------------------------------------------

        this.update = function (data) {
            if (!data) { return; }
            // set placeholder picture as default and reset author halo link
            authorLinkNode.removeClass('halo-link').removeData();
            // fetch user photo and enable halo view only if author OX User ID is available

            authorLinkNode.attr('data-user-index', data.authorColorIndex).text(data.author);
            dateNode.text(data.date);
            actionNode.text(data.action);

            if (data.authorUserId) {
                Utils.getUserInfo(data.authorUserId).done(function (info) {
                    var displayName = info.displayName;
                    self.setValue({ userId: data.authorUserId, userName: displayName });
                    authorLinkNode.text(displayName);

                    if (!info.guest && !DriveUtils.isGuest()) {
                        authorLinkNode.addClass('halo-link').data('internal_userid', data.authorUserId);
                    }
                });
            }
        };

        // initialization -----------------------------------------------------

        this.getNode().addClass('change-track-badge');

        // insert nodes to group node
        descriptionNode.append(authorLinkNode, actionNode);
        this.addChildNodes(descriptionNode, dateNode);

        // ARIA role
        this.getNode().attr('role', 'dialog');

        // destroy all class members
        this.registerDestructor(function () {
            self = docView = initOptions = null;
            authorLinkNode = dateNode = actionNode = descriptionNode = null;
        });

    } // class ChangeTrackBadge

    // exports ================================================================

    // derive this class from class UserPicture
    return UserPicture.extend({ constructor: ChangeTrackBadge });

});
