/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/textframework/utils/operations', [
    'io.ox/office/editframework/utils/operations'
], function (EditOperations) {

    'use strict';

    // static class TextOperations ============================================

    /**
     * Provides constants for the names of all document operations used in text
     * documents.
     *
     * @extends EditOperations
     */
    var TextOperations = _.extend(EditOperations, {

        SET_ATTRIBUTES: 'setAttributes',
        DELETE: 'delete',
        MOVE: 'move',

        TEXT_INSERT: 'insertText',
        DRAWING_INSERT: 'insertDrawing',
        FIELD_INSERT: 'insertField',
        FIELD_UPDATE: 'updateField',
        COMPLEXFIELD_INSERT: 'insertComplexField',
        COMPLEXFIELD_UPDATE: 'updateComplexField',
        TAB_INSERT: 'insertTab',
        HARDBREAK_INSERT: 'insertHardBreak',
        COMMENT_INSERT: 'insertComment',
        RANGE_INSERT: 'insertRange',

        PARA_INSERT: 'insertParagraph',
        PARA_SPLIT: 'splitParagraph',
        PARA_MERGE: 'mergeParagraph',

        TABLE_INSERT: 'insertTable',
        ROWS_INSERT: 'insertRows',
        CELLS_INSERT: 'insertCells',
        CELL_SPLIT: 'splitCell',
        CELL_MERGE: 'mergeCell',
        COLUMN_INSERT: 'insertColumn',
        COLUMNS_DELETE: 'deleteColumns',
        TABLE_SPLIT: 'splitTable',
        TABLE_MERGE: 'mergeTable',

        INSERT_LIST: 'insertListStyle',
        DELETE_LIST: 'deleteListStyle',
        INSERT_HEADER_FOOTER: 'insertHeaderFooter',
        DELETE_HEADER_FOOTER: 'deleteHeaderFooter'

    });

    // exports ================================================================

    return TextOperations;

});
