/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/formula/impl/databasefuncs', function () {

    'use strict';

    /**************************************************************************
     *
     * This module implements all spreadsheet functions treating cell ranges
     * like minimal databases.
     *
     * See the README file in this directory for a detailed documentation about
     * the format of function descriptor objects.
     *
     *************************************************************************/

    // exports ================================================================

    return {

        DAVERAGE: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DCOUNT: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DCOUNTA: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DGET: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DMAX: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DMIN: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DPRODUCT: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DSTDEV: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DSTDEVP: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DSUM: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DVAR: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        },

        DVARP: {
            category: 'database',
            minParams: 3,
            maxParams: 3,
            type: 'val',
            signature: 'ref:single val val'
        }
    };

});
