/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/presentation/utils/operations', [
    'io.ox/office/textframework/utils/operations'
], function (TextOperations) {

    'use strict';

    // static class PresentationOperations ============================================

    /**
     * Provides constants for the names of all document operations used in presentation
     * documents.
     *
     * @extends TextEditOperations
     */
    var PresentationOperations = _.extend(TextOperations, {

        SLIDE_INSERT: 'insertSlide', // TODO: Shift this into presentation
        MASTER_SLIDE_INSERT: 'insertMasterSlide',
        LAYOUT_SLIDE_INSERT: 'insertLayoutSlide'

    });

    // exports ================================================================

    return PresentationOperations;

});
