/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Sven Jacobi <sven.jacobi@open-xchange.com>
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/presentation/app/application', [
    'io.ox/office/editframework/app/editapplication',
    'io.ox/office/presentation/model/model',
    'io.ox/office/presentation/view/view',
    'io.ox/office/presentation/app/controller'
], function (EditApplication, PresentationModel, PresentationView, PresentationController) {

    'use strict';

    // class PresentationApplication ==========================================

    /**
     * The OX Presentation application.
     *
     * @constructor
     *
     * @extends EditApplication
     *
     * @param {Object} launchOptions
     *  All options passed to the core launcher (the ox.launch() method).
     */
    var PresentationApplication = EditApplication.extend({ constructor: function (launchOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        EditApplication.call(this, PresentationModel, PresentationView, PresentationController, launchOptions, {
            postProcessHandler: postProcessDocument,
            optimizeOperationsHandler: optimizeOperations,
            sendActionsDelay: 1000,
            localStorageApp: false
        });

        // private methods ----------------------------------------------------

        /**
         * Optimizing the actions (operations) before sending them to the server.
         *
         * @param {Object[]} actionsBuffer
         *  An array with actions.
         *
         * @returns {Object[]}
         *  The optimized array with actions.
         */
        function optimizeOperations(actionsBuffer) {
            return self.getModel().optimizeActions(actionsBuffer);
        }

        /**
         * Post-processes the document contents and formatting, after all its
         * import operations have been applied.
         *
         * @returns {jQuery.Promise}
         *  The promise of a Deferred object that will be resolved when the
         *  document has been post-processed successfully, or rejected when an
         *  error has occurred.
         */
        function postProcessDocument() {
            return self.getModel().updateDocumentFormatting();
        }

        // initialization -----------------------------------------------------

        // destroy all class members
        this.registerDestructor(function () {
            launchOptions = null;
        });

    } }); // class PresentationApplication

    // static methods ---------------------------------------------------------

    /**
     * Replacement for the generic method EditApplication.createLauncher()
     * without parameters, to launch presentation applications.
     */
    PresentationApplication.createLauncher = function () {
        return EditApplication.createLauncher('io.ox/office/presentation', PresentationApplication, { icon: 'fa-film' });
    };

    // exports ================================================================

    return PresentationApplication;

});
