/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
  * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/drawingcontrols', [
    'io.ox/office/drawinglayer/view/control/charttypepicker',
    'io.ox/office/drawinglayer/view/control/chartcolorsetpicker',
    'io.ox/office/drawinglayer/view/control/chartstylesetpicker',
    'io.ox/office/drawinglayer/view/control/chartlegendpicker',
    'io.ox/office/baseframework/view/control/compoundsplitbutton',
    'io.ox/office/drawinglayer/view/drawinglabels',
    'io.ox/office/tk/controls',
    'gettext!io.ox/office/drawinglayer/main'
], function (ChartTypePicker, ChartColorSetPicker, ChartStyleSetPicker, ChartLegendPicker, CompoundSplitButton, DrawingLabels, Controls, gt) {

    'use strict';

    // static class DrawingControls ===========================================

    /**
     * Provides different classes for GUI form controls for drawing objects in
     * a single map for convenience.
     */
    var DrawingControls = {
        ChartTypePicker: ChartTypePicker,
        ChartColorSetPicker: ChartColorSetPicker,
        ChartStyleSetPicker: ChartStyleSetPicker,
        ChartLegendPicker: ChartLegendPicker
    };

    DrawingControls.ImagePicker = CompoundSplitButton.extend({ constructor: function (docView) {

        // base constructor ---------------------------------------------------

        CompoundSplitButton.call(this, docView, {
            icon: 'docs-image-insert',
            label: DrawingLabels.INSERT_DRAWING_LABEL,
            tooltip: DrawingLabels.INSERT_DRAWING_TOOLTIP,
            smallerVersion: {
                css: { width: 35 },
                hideLabel: true
            },
            value: 'drive'
        });

        var dialogTypeGroup =   new Controls.RadioGroup();

        dialogTypeGroup.createOptionButton('local',  { label: /*#. Contextmenu item label for insert image from the local file system. */ gt('Local file') });

        dialogTypeGroup.createOptionButton('drive',  { label: /*#. Contextmenu item label for insert image from drive. Please do not translate the productname 'Drive' */ gt('From Drive') });

        dialogTypeGroup.createOptionButton('url',   { label:  /*#. Contextmenu item label for insert image from an url. */ gt('From URL') });

        this.addGroup('image/insert/dialog', dialogTypeGroup);
    } });

    // exports ================================================================

    return DrawingControls;

});
