/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/tk/utils/fontmetrics'
], function (FontMetrics) {

    'use strict';

    // static class FontMetrics ===============================================

    describe('Toolkit module FontMetrics', function () {

        it('should exist', function () {
            expect(FontMetrics).to.be.an('object');
        });

        // constants ----------------------------------------------------------

        describe('constant "AUTO_BIDI_SUPPORT"', function () {
            it('should exist', function () {
                expect(FontMetrics.AUTO_BIDI_SUPPORT).to.be.a('boolean');
            });
        });

        // static methods -----------------------------------------------------

        describe('method "getTextDirection"', function () {
            var LTR_TEXT = 'abc',
                RTL_TEXT = '\u05d0\u05d1\u05d2',
                LTR = 'ltr',
                RTL = FontMetrics.AUTO_BIDI_SUPPORT ? 'rtl' : 'ltr';
            it('should exist', function () {
                expect(FontMetrics).itself.to.respondTo('getTextDirection');
            });
            it('should return "ltr" for western text', function () {
                expect(FontMetrics.getTextDirection(LTR_TEXT)).to.equal(LTR);
                expect(FontMetrics.getTextDirection('  ' + LTR_TEXT)).to.equal(LTR);
            });
            it('should return "' + RTL + '" for complex text', function () {
                expect(FontMetrics.getTextDirection(RTL_TEXT)).to.equal(RTL);
                expect(FontMetrics.getTextDirection('  ' + RTL_TEXT)).to.equal(RTL);
            });
            it('should return correct direction for mixed text', function () {
                expect(FontMetrics.getTextDirection(LTR_TEXT + ' ' + RTL_TEXT)).to.equal(LTR);
                expect(FontMetrics.getTextDirection(RTL_TEXT + ' ' + LTR_TEXT)).to.equal(RTL);
            });
            it('should return "ltr" for undetermined text', function () {
                expect(FontMetrics.getTextDirection('')).to.equal(LTR);
                expect(FontMetrics.getTextDirection('  ')).to.equal(LTR);
                expect(FontMetrics.getTextDirection('.')).to.equal(LTR);
                expect(FontMetrics.getTextDirection('123')).to.equal(LTR);
            });
        });
    });

    // ========================================================================
});
