/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/tk/utils/fontdescriptor'
], function (FontDescriptor) {

    'use strict';

    // class FontDescriptor ===================================================

    describe('Toolkit class FontDescriptor', function () {

        it('should exist', function () {
            expect(FontDescriptor).to.be.a('function');
        });

        // constructor --------------------------------------------------------

        describe('constructor', function () {
            it('should take all parameters', function () {
                var fontDesc = new FontDescriptor('times', 10, false, true);
                expect(fontDesc).to.have.property('family', 'times');
                expect(fontDesc).to.have.property('size', 10);
                expect(fontDesc).to.have.property('bold', false);
                expect(fontDesc).to.have.property('italic', true);
            });
            it('should convert font name to lower-case', function () {
                var fontDesc = new FontDescriptor('TiMeS', 10.25, false, true);
                expect(fontDesc).to.have.property('family', 'times');
            });
            it('should round font size', function () {
                var fontDesc = new FontDescriptor('times', 10.25, false, true);
                expect(fontDesc).to.have.property('size', 10.3);
            });
            it('should accept missing flags', function () {
                var fontDesc = new FontDescriptor('times', 10);
                expect(fontDesc).to.have.property('bold', false);
                expect(fontDesc).to.have.property('italic', false);
            });
        });

        // public methods -----------------------------------------------------

        describe('method "key"', function () {
            it('should exist', function () {
                expect(FontDescriptor).to.respondTo('key');
            });
            it('should return a string', function () {
                var fontDesc = new FontDescriptor('times', 10, false, true);
                expect(fontDesc.key()).to.be.a.string;
            });
            it('should return different keys for different font names', function () {
                var fontDesc1 = new FontDescriptor('times1', 10, false, true),
                    fontDesc2 = new FontDescriptor('times2', 10, false, true);
                expect(fontDesc1.key()).to.not.equal(fontDesc2.key());
            });
            it('should return different keys for different font sizes', function () {
                var fontDesc1 = new FontDescriptor('times', 10, false, true),
                    fontDesc2 = new FontDescriptor('times', 11, false, true);
                expect(fontDesc1.key()).to.not.equal(fontDesc2.key());
            });
            it('should return different keys for different bold flags', function () {
                var fontDesc1 = new FontDescriptor('times', 10, false, true),
                    fontDesc2 = new FontDescriptor('times', 10, true, true);
                expect(fontDesc1.key()).to.not.equal(fontDesc2.key());
            });
            it('should return different keys for different italic flags', function () {
                var fontDesc1 = new FontDescriptor('times', 10, false, true),
                    fontDesc2 = new FontDescriptor('times', 10, false, false);
                expect(fontDesc1.key()).to.not.equal(fontDesc2.key());
            });
        });

        describe('method "getCanvasFont"', function () {
            it('should exist', function () {
                expect(FontDescriptor).to.respondTo('getCanvasFont');
            });
            it('should return the canvas font style', function () {
                expect(new FontDescriptor('times', 10, false, false).getCanvasFont()).to.equal('10pt times');
                expect(new FontDescriptor('times,serif', 10, false, false).getCanvasFont()).to.equal('10pt times,serif');
                expect(new FontDescriptor('times', 10, true, false).getCanvasFont()).to.equal('bold 10pt times');
                expect(new FontDescriptor('times', 10, false, true).getCanvasFont()).to.equal('italic 10pt times');
                expect(new FontDescriptor('times', 10, true, true).getCanvasFont()).to.equal('bold italic 10pt times');
            });
        });
    });

    // ========================================================================
});
