/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    var fs = require('fs');
    var conf = grunt.config().local.appserver;
    var proto = (conf && conf.protocol === 'https') ? 'https' : 'http';

    var net = require('net');
    var server = net.createServer();
    server.on('error', function () {
        grunt.verbose.writeln('Livereload instance running, will enable send_livereload task.');
    });
    server.listen(35729, function () {
        var lrConf = true;
        grunt.verbose.writeln('No Livereload instance running, will configure watch to start one.');
        if (proto === 'https') {
            lrConf = {
                key: grunt.file.read('node_modules/grunt-contrib-connect/tasks/certs/server.key'),
                cert: grunt.file.read('node_modules/grunt-contrib-connect/tasks/certs/server.crt')
            };
        }
        grunt.config.set('watch.manifests.options.livereload', lrConf);
        grunt.config.set('watch.configs.options.livereload', lrConf);
        if (grunt.task.current.name === 'watch') {
            grunt.task.run('watch');
        }
        server.close();
    });

    grunt.registerTask('send_livereload', function () {
        var done = this.async();
        if (!!grunt.config('watch.configs.options.livereload')) {
            grunt.verbose.writeln('Using livereload from watch');
            done();
            return;
        }
        var http = require(proto);
        var req = http.request({
            hostname: 'localhost',
            port: 35729,
            path: '/changed',
            method: 'POST',
            rejectUnauthorized: false
        }, function () {
            grunt.verbose.writeln('Livereload request sent');
            done();
        });
        req.on('error', function (err) {
            grunt.log.warn('Could not send livereload:', err);
            done();
        });
        req.write(JSON.stringify({ files: ['boot.js'] }));
        req.end();
    });

    // force cache-busting
    grunt.registerTask('force_update', function () {
        fs.utimesSync('build/', new Date(), new Date());
    });

    // steps to build and test the ui (ready for development)
    grunt.registerTask('build_test_reload', ['build', 'test:manually', 'send_livereload']);

    grunt.config.extend('watch', {

        options: {
            interval: 500,
            interrupt: true,
            debounceDelay: 500
        },

        manifests: {
            files: ['apps/**/manifest.json'],
            tasks: ['manifests', 'force_update', 'test:manually', 'send_livereload']
        },

        // simply reload watch configuration after changing *this* file
        self: {
            options: { reload: true },
            files: ['grunt/tasks/watch.js']
        },

        configs: {
            options: { reload: true },
            files: ['package.json', 'Gruntfile.js', 'grunt/tasks/*.js', '!grunt/tasks/watch.js', 'bower.json', '**/.*rc', 'karma.conf.js'],
            tasks: ['clean', 'build_test_reload']
        },

        apps_change: {
            options: { event: 'changed' },
            files: ['apps/**/*.{js,json,less}', 'lib/**/*.{js,less}', 'icons/**/*.{json,png}'],
            tasks: ['build_test_reload']
        },

        // full build after adding/deleting files (clean-up build directory, re-check required modules in other files)
        apps_full: {
            options: { event: ['added', 'deleted'] },
            files: ['apps/**/*.{js,json,less}', 'lib/**/*.{js,less}', 'icons/**/*.{json,png}'],
            tasks: ['clean', 'build_test_reload']
        },

        spec_change: {
            options: { event: 'changed' },
            files: ['spec/**/*.js'],
            tasks: ['lint', 'newer:copy:specs', 'test:manually']
        },

        // full build after adding/deleting files (clean-up build directory, re-check required modules in other files)
        spec_full: {
            options: { event: ['added', 'deleted'] },
            files: ['spec/**/*.js'],
            tasks: ['clean', 'build_test_reload']
        }
    });

    grunt.loadNpmTasks('grunt-contrib-watch');
};
