/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/app/controller', ['io.ox/office/editframework/app/editcontroller'], function (EditController) {

    'use strict';

    // class PresentationController ===========================================

    /**
     * The controller of an OX Presentation application.
     *
     * @constructor
     *
     * @extends EditController
     */
    function PresentationController(app, docModel, docView) {

        // base constructor ---------------------------------------------------

        EditController.call(this, app, docModel, docView);

        // initialization -----------------------------------------------------

        // register all controller items
        this.registerDefinitions({
        });

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = docModel = docView = null;
        });

    } // class PresentationController

    // exports ================================================================

    // derive this class from class EditController
    return EditController.extend({ constructor: PresentationController });

});
