/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/collection/documentcollection', [
    'io.ox/office/portal/model/documentmodel'
], function (DocumentModel) {

    'use strict';

    var documentCollection = Backbone.Collection.extend({

        model: DocumentModel,

        setData: function (recentsArray) {

            var self = this;

            // populate the collection with recent documents
            _.each(recentsArray, function (recentDocument) {
                self.add(new DocumentModel(recentDocument), { merge: true });
            });

        }

    });

    return documentCollection;

});
