/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/control/fontsizepicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/combofield',
    'gettext!io.ox/office/editframework/main'
], function (Utils, ComboField, gt) {

    'use strict';

    // class FontSizePicker ===================================================

    /**
     * A combo-box control used to select a font height.
     *
     * @constructor
     *
     * @extends ComboField
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options of the base class ComboField.
     */
    function FontSizePicker(initOptions) {

        // base constructor ---------------------------------------------------

        ComboField.call(this, Utils.extendOptions({
            width: 40,
            tooltip: gt('Font size'),
            style: 'text-align:right;',
            keyboard: 'number',
            validator: new ComboField.NumberValidator({ min: 1, max: 999.9, precision: 0.1 })
        }, initOptions));

        // initialization -----------------------------------------------------

        [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 22, 24, 26, 28, 32, 36, 40, 44, 48, 54, 60, 66, 72, 80, 88, 96].forEach(function (size) {
            this.createListEntry(size, { label: _.noI18n(String(size)), style: 'text-align:right;padding-right:20px;' });
        }, this);

    } // class FontSizePicker

    // exports ================================================================

    // derive this class from class ComboField
    return ComboField.extend({ constructor: FontSizePicker });

});
