/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/control/applicationstatuslabel', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/label',
    'gettext!io.ox/office/editframework/main'
], function (Utils, Label, gt) {

    'use strict';

    // class ApplicationStatusLabel ===========================================

    /**
     * Shows the current status of the application when it has changed.
     *
     * @constructor
     *
     * @extends Label
     *
     * @param {EditView} docView
     *  The document view instance containing this control.
     */
    function ApplicationStatusLabel(docView, initOptions) {

        var // self reference
            self = this,

            // all captions for the different application states
            captions = {
                preview: { icon: 'fa-refresh', iconClasses: 'fa-spin', label: /*#. label shown in the toolbar while the document is loading */ gt('Loading document') },
                sending: { icon: 'fa-refresh', iconClasses: 'fa-spin', label: /*#. label shown in the toolbar while user changes are sent to the server */ gt('Saving changes') },
                ready:   { icon: 'fa-check', label: gt('All changes saved') }
            };

        // base constructor ---------------------------------------------------

        Label.call(this, _.extend(initOptions, { classes: 'app-status-label', minWidth: 200 }));

        // initialization -----------------------------------------------------

        // make label node an ARIA live region
        this.getLabelNode().attr({
            role: 'status',
            'aria-live': 'polite',
            'aria-relevant': 'additions',
            'aria-atomic': true,
            'aria-readonly': true
        });

        // update caption according to application status
        this.listenTo(docView.getApp(), 'docs:state', function (state) {
            self.setCaption(captions[state]);
        });

        // destroy class members on destruction
        this.registerDestructor(function () {
            docView = self = null;
        });

    } // class ApplicationStatusLabel

    // exports ================================================================

    // derive this class from class Label
    return Label.extend({ constructor: ApplicationStatusLabel });

});
