/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/baseframework/utils/apprestoremixin', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/restore/sessionrestore'
], function (Utils, Restore) {

    'use strict';

    // mix-in class AppRestoreMixin ================================================

    function AppRestoreMixin () {

        var // self reference
            self = this;

        // private methods ----------------------------------------------------

        function getLaunchOptions() {
            var file = self.getFileDescriptor();

            return {
                action: 'load',
                file: file,
                module: self.getName() + '/main',
                hidden: true
            };
        }
        function stateHandler(keySource, param) {
            if (!keySource.file) {
                //file could not be created!!! (permissions or quota)
                return;
            }
            var key = keySource.file.id + '~' + keySource.module;
            Restore.state(key, param);
        }

        // public methods -----------------------------------------------------

        // initialization -----------------------------------------------------

        self.getImportStartPromise().done(function () {
            self.registerVisibleStateHandler(function (visible) {
                var launchOptions = getLaunchOptions();
                if (visible) {
                    stateHandler(launchOptions, null);
                } else {
                    stateHandler(launchOptions, launchOptions);
                }
            });
        });

        self.registerQuitHandler(function (reason) {
            var launchOptions = getLaunchOptions();
            if (reason !== 'unload') {
                stateHandler(launchOptions, null);
            }
        });

        // destroy all class members on destruction
        this.registerDestructor(function () {
            self = null;
        });

    } // class AppRestoreMixin

    // exports ================================================================

    return AppRestoreMixin;

});
