/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/tk/utils/dateutils'
], function (DateUtils) {

    'use strict';

    // static class DateUtils =================================================

    describe('Toolkit module DateUtils', function () {

        it('should exist', function () {
            expect(DateUtils).to.be.an('object');
        });

        // static methods -----------------------------------------------------

        describe('method "convertUTCDateToLocalDate"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('convertUTCDateToLocalDate');
            });
            it('should convert UTC date to local date', function () {
                expect(DateUtils.convertUTCDateToLocalDate('2007-08-31T16:47+00:00')).to.equal('2007-08-31T18:47:00Z');
                expect(DateUtils.convertUTCDateToLocalDate('2007-08-31T16:47+00:00', { useMilliSeconds: true })).to.equal('2007-08-31T18:47:00.000Z');
            });
        });

        describe('method "getIsoDateString"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getIsoDateString');
            });
            it('should create an ISO conform date string', function () {
                expect(DateUtils.getIsoDateString()).to.be.a('string');
                expect(DateUtils.getIsoDateString().length).to.equal(24);
                expect(DateUtils.getIsoDateString({ useSeconds: true }).length).to.equal(24);
                expect(DateUtils.getIsoDateString({ useSeconds: false })).to.be.a('string');
                expect(DateUtils.getIsoDateString({ useSeconds: false }).length).to.equal(20);
                expect(DateUtils.getIsoDateString().match(/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/)[0]).to.be.a('string');
                expect(DateUtils.getIsoDateString({ useSeconds: false }).match(/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:00Z$/)[0]).to.be.a('string');
            });
        });

        describe('method "getMSFormatIsoDateString"', function () {
            it('should exist', function () {
                expect(DateUtils).itself.to.respondTo('getMSFormatIsoDateString');
            });
            it('should create an iso conform date string', function () {
                expect(DateUtils.getMSFormatIsoDateString()).to.be.a('string');
                expect(DateUtils.getMSFormatIsoDateString({ useSeconds: false })).to.be.a('string');
            });
        });
    });

    // ========================================================================
});
