/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/utils/config', [
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/utils/editconfig'
], function (Utils, EditConfig) {

    'use strict';

    // static class TextConfig ================================================

    var TextConfig = _.clone(EditConfig);

    /**
     * A Boolean flag specifying whether online spelling is enabled.
     *
     * @constant
     */
    TextConfig.SPELLING_ENABLED = TextConfig.getFlag('spellingEnabled', true);

    /**
     * The maximum number of cells supported in a text table. If the server
     * configuration item is missing, the default of 1500 used.
     * ATTENTION: If you change this value, please make sure that the server
     * side is also changed.
     *
     * @constant
     */
    TextConfig.MAX_TABLE_CELLS = Utils.getIntegerOption(TextConfig.get(), 'maxTableCells', 1500, 0);

    /**
     * The maximum number of rows supported in a text table. If the server
     * configuration item is missing, the default of 1500 is used.
     * ATTENTION: If you change this value, please make sure that the server
     * side is also changed.
     *
     * @constant
     */
    TextConfig.MAX_TABLE_ROWS = Utils.getIntegerOption(TextConfig.get(), 'maxTableRows', 1500, 0);

    /**
     * The maximum number of columns supported in a text table. If the server
     * configuration item is missing, the default of 15 is used.
     * ATTENTION: If you change this value, please make sure that the server
     * side is also changed.
     *
     * @constant
     */
    TextConfig.MAX_TABLE_COLUMNS = Utils.getIntegerOption(TextConfig.get(), 'maxTableColumns', 15, 0);

    // global initialization --------------------------------------------------

    // restrict MAX_TABLE_COLUMNS and MAX_TABLE_ROWS according to MAX_TABLE_CELLS
    if (TextConfig.MAX_TABLE_CELLS < (TextConfig.MAX_TABLE_COLUMNS * TextConfig.MAX_TABLE_ROWS)) {
        (function () {

            var // start with the square root of the cell count for both limits (columns and rows)
                maxCount = Math.floor(Math.sqrt(TextConfig.MAX_TABLE_CELLS));

            // respect the original limits for columns and rows
            if (maxCount > TextConfig.MAX_TABLE_ROWS) {
                TextConfig.MAX_TABLE_COLUMNS = Math.floor(TextConfig.MAX_TABLE_CELLS / TextConfig.MAX_TABLE_ROWS);
            } else if (maxCount > TextConfig.MAX_TABLE_COLUMNS) {
                TextConfig.MAX_TABLE_ROWS = Math.floor(TextConfig.MAX_TABLE_CELLS / TextConfig.MAX_TABLE_COLUMNS);
            } else {
                TextConfig.MAX_TABLE_COLUMNS = TextConfig.MAX_TABLE_ROWS = maxCount;
            }
        }());
    }

    // exports ================================================================

    return TextConfig;

});
