/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/legendmodel', [
    'io.ox/office/drawinglayer/view/chartstyleutil',
    'io.ox/office/editframework/model/attributedmodel'
], function (ChartStyleUtil, AttributedModel) {

    'use strict';

    // class LegendModel ======================================================

    /**
     *
     * @constructor
     *
     * @extends AttributedModel
     */
    function LegendModel(chartModel, attrs, dataLegend) {

        var self = this;

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chartModel.getDocModel(), attrs, { families: 'legend character' });

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            var att = self.getMergedAttributes();
            var legendPos = att.legend.pos;
            switch (legendPos) {
            case 'bottom':
            case 'top':
                dataLegend.verticalAlign = legendPos;
                dataLegend.horizontalAlign = 'center';
                break;
            case 'left':
            case 'right':
                dataLegend.verticalAlign = 'center';
                dataLegend.horizontalAlign = legendPos;
                break;
            case 'topRight':
                dataLegend.verticalAlign = 'top';
                dataLegend.horizontalAlign = 'right';
                break;
            }

            if (legendPos !== 'off') {
                ChartStyleUtil.handleCharacterProps(chartModel, att.character, dataLegend);
                if (dataLegend.forceSmall) {
                    dataLegend.fontSize = Math.round(dataLegend.fontSize / 4 * 3);
                }
            }
        };

    } // class LegendModel

    // exports ================================================================

    return AttributedModel.extend({ constructor: LegendModel });

});
