/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/model/modelattributesmixin', function () {

    'use strict';

    // definitions for global document attributes -----------------------------

    var DOCUMENT_ATTRIBUTE_DEFINITIONS = {};

    // mix-in class ModelAttributesMixin ======================================

    /**
     * A mix-in class for the document model class PresentationModel providing
     * the style sheet containers for all attribute families used in a
     * presentation document.
     *
     * @constructor
     */
    function ModelAttributesMixin() {

        // initialization -----------------------------------------------------

        this.registerAttributeDefinitions('document', DOCUMENT_ATTRIBUTE_DEFINITIONS);

    } // class ModelAttributesMixin

    // exports ================================================================

    return ModelAttributesMixin;

});
