/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/model/model',
[
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/model/editmodel',
    'io.ox/office/presentation/model/modelattributesmixin'
], function (Utils, EditModel, ModelAttributesMixin) {

    'use strict';

    // class PresentationModel ================================================

    /**
     * Represents the document model of a presentation application.
     *
     * Triggers the events supported by the base class EditModel.
     *
     * @constructor
     *
     * @extends EditModel
     * @extends ModelAttributesMixin
     *
     * @param {PresentationApplication} app
     *  The application containing this document model.
     */
    function PresentationModel(app) {

        // base constructor ---------------------------------------------------

        EditModel.call(this, app);
        ModelAttributesMixin.call(this);

        // private methods ----------------------------------------------------

        // public methods -----------------------------------------------------

        // initialization -----------------------------------------------------

    } // class PresentationModel

    // exports ================================================================

    // derive this class from class EditModel
    return EditModel.extend({ constructor: PresentationModel });

});
