/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define(['io.ox/office/spreadsheet/view/labels'], function (Labels) {

    'use strict';

    describe('OX Spreadsheet', function () {
        describe('SpreadsheetLabels module', function () {

            it('should exist', function () {
                expect(Labels).to.be.an('object');
            });

            // methods ========================================================

            describe('method "getColLabel"', function () {
                it('should exist', function () {
                    expect(Labels).itself.to.respondTo('getColLabel');
                });
                it('should return the English column label', function () {
                    expect(Labels.getColLabel(0)).to.equal('Column A');
                    expect(Labels.getColLabel(1)).to.equal('Column B');
                    expect(Labels.getColLabel(25)).to.equal('Column Z');
                    expect(Labels.getColLabel(26)).to.equal('Column AA');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getRowLabel"', function () {
                it('should exist', function () {
                    expect(Labels).itself.to.respondTo('getRowLabel');
                });
                it('should return the English row label', function () {
                    expect(Labels.getRowLabel(0)).to.equal('Row 1');
                    expect(Labels.getRowLabel(1)).to.equal('Row 2');
                    expect(Labels.getRowLabel(8)).to.equal('Row 9');
                    expect(Labels.getRowLabel(9)).to.equal('Row 10');
                });
            });

            // ----------------------------------------------------------------

            describe('method "getSheetName"', function () {
                it('should exist', function () {
                    expect(Labels).itself.to.respondTo('getSheetName');
                });
                it('should return the English sheet name', function () {
                    expect(Labels.getSheetName(0)).to.equal('Sheet1');
                    expect(Labels.getSheetName(1)).to.equal('Sheet2');
                    expect(Labels.getSheetName(9)).to.equal('Sheet10');
                });
            });

            // ----------------------------------------------------------------

        });
    });
});
