#!/bin/bash
#
# This work is provided under the terms of the CREATIVE COMMONS PUBLIC
# LICENSE. This work is protected by copyright and/or other applicable
# law. Any use of the work other than as authorized under this license
# or copyright law is prohibited.
#
# http://creativecommons.org/licenses/by-nc-sa/2.5/
#
# © 2016 OX Software GmbH.
#
# @author Daniel Rentz <daniel.rentz@open-xchange.com>
#

LD_LIBRARY_PATH="$MAGICK_HOME/lib"
DYLD_LIBRARY_PATH="$MAGICK_HOME/lib"

OUT=build
ICONSET_LESS=$OUT/docs-icons.less
ICONSET16_BLACK=$OUT/docs-icons-desktop-black.png
ICONSET16_WHITE=$OUT/docs-icons-desktop-white.png
ICONSET32_BLACK=$OUT/docs-icons-retina-black.png
ICONSET32_WHITE=$OUT/docs-icons-retina-white.png

SOURCE_SIZE=16
LINE_SIZE=20

mkdir $OUT 2> /dev/null

# generate the CSS file and count existing icons

echo preparing $ICONSET_LESS
let ICON_SIZE=SOURCE_SIZE+2
let RETINA_SIZE=ICON_SIZE*2
cat header.txt > $ICONSET_LESS
echo ".io-ox-office-main i[class^=\"docs-\"] {" >> $ICONSET_LESS
echo "    width: ${ICON_SIZE}px;" >> $ICONSET_LESS
echo "    height: ${ICON_SIZE}px;" >> $ICONSET_LESS
echo "    &.docs-empty { background-position: 0 0; }" >> $ICONSET_LESS
echo reading icons.txt
INDEX=1
while read LINE; do
    TOKENS=($(echo ${LINE%%#*} | tr -d "\r"))
    LEN=${#TOKENS[@]}
    if [ $LEN -ge 2 ]; then
        FILENAMES[$INDEX]=${TOKENS[0]}
        let POSX=-INDEX%LINE_SIZE*ICON_SIZE
        let POSY=-INDEX/LINE_SIZE*ICON_SIZE
        for TOKEN in ${TOKENS[@]:1}; do
            echo "    &.docs-$TOKEN { background-position: ${POSX}px ${POSY}px; }" >> $ICONSET_LESS
        done
        let INDEX+=1
    fi
done < icons.txt
[ $INDEX -lt $LINE_SIZE ] && let ICONSET_WIDTH=ICON_SIZE || let ICONSET_WIDTH=LINE_SIZE
let ICONSET_HEIGHT=(INDEX-1)/LINE_SIZE+1 
let ICONSET_WIDTH*=ICON_SIZE
let ICONSET_HEIGHT*=ICON_SIZE
echo "    background-size: ${ICONSET_WIDTH}px ${ICONSET_HEIGHT}px;" >> $ICONSET_LESS
echo "}" >> $ICONSET_LESS

# generate the icon sets

echo creating icon sets
convert -size ${ICONSET_WIDTH}x$ICONSET_HEIGHT xc:none $ICONSET16_BLACK
let ICONSET_WIDTH*=2
let ICONSET_HEIGHT*=2
convert -size ${ICONSET_WIDTH}x$ICONSET_HEIGHT xc:none $ICONSET32_BLACK
INDEX=1
for FILENAME in ${FILENAMES[@]}; do
    echo processing icon $FILENAME
    let POSX=(INDEX%LINE_SIZE)*ICON_SIZE+1
    let POSY=(INDEX/LINE_SIZE)*ICON_SIZE+1
    let POSX2=POSX*2
    let POSY2=POSY*2
    FILENAME16=images/${FILENAME}_16.png
    FILENAME32=images/${FILENAME}_32.png
    composite -geometry +${POSX}+${POSY} "$FILENAME16" $ICONSET16_BLACK $ICONSET16_BLACK
    composite -geometry +${POSX2}+${POSY2} "$FILENAME32" $ICONSET32_BLACK $ICONSET32_BLACK
    let INDEX+=1
done
echo converting colors
convert $ICONSET16_BLACK -fuzz 100% -fill \#333333 -opaque \#333333 $ICONSET16_BLACK
convert $ICONSET16_BLACK -fuzz 100% -fill \#ffffff -opaque \#ffffff $ICONSET16_WHITE
convert $ICONSET32_BLACK -fuzz 100% -fill \#333333 -opaque \#333333 $ICONSET32_BLACK
convert $ICONSET32_BLACK -fuzz 100% -fill \#ffffff -opaque \#ffffff $ICONSET32_WHITE
echo done
