/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/view/labels', [
    'io.ox/office/editframework/view/editlabels',
    'gettext!io.ox/office/text'
], function (EditLabels, gt) {

    'use strict';

    // static class TextLabels ================================================

    /**
     * Provides generic caption texts for control groups, menu headers, and
     * other GUI elements for the Text application in a single map for
     * convenience.
     *
     * @extends EditLabels
     */
    var TextLabels = _.extend({}, EditLabels);

    // control labels and icons -----------------------------------------------

    /**
     * @constant
     */
    TextLabels.PARA_ALIGNMENT_LABEL = /*#. horizontal text alignment in a paragraph */ gt('Paragraph alignment');

    /**
     * @constant
     */
    TextLabels.TEXT_POSITION_LABEL = /*#. vertical text position (subscript/superscript) */ gt('Text position');

    /**
     * @constant
     */
    TextLabels.LINE_SPACING_LABEL = /*#. distance between lines of text in a paragraph */ gt('Line spacing');

    /**
     * An array with style options for all supported paragraph alignments.
     *
     * @constant
     */
    TextLabels.PARA_ALIGNMENT_STYLES = [
        { value: 'left',    icon: 'docs-para-align-left',    label: EditLabels.HOR_ALIGNMENT_LABELS.left    },
        { value: 'center',  icon: 'docs-para-align-center',  label: EditLabels.HOR_ALIGNMENT_LABELS.center  },
        { value: 'right',   icon: 'docs-para-align-right',   label: EditLabels.HOR_ALIGNMENT_LABELS.right   },
        { value: 'justify', icon: 'docs-para-align-justify', label: EditLabels.HOR_ALIGNMENT_LABELS.justify }
    ];

    // exports ================================================================

    return TextLabels;

});
